/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.servlet;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.ParametersMissingException;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.servlet.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerMapping;

public class WebMvcEndpointHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private final Method handle = ReflectionUtils.findMethod(OperationHandler.class, (String)"handle", (Class[])new Class[]{HttpServletRequest.class, Map.class});
    private final Method links = ReflectionUtils.findMethod(WebMvcEndpointHandlerMapping.class, (String)"links", (Class[])new Class[]{HttpServletRequest.class});
    private final EndpointLinksResolver endpointLinksResolver = new EndpointLinksResolver();

    public WebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> collection) {
        this(endpointMapping, collection, null);
    }

    public WebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> webEndpoints, CorsConfiguration corsConfiguration) {
        super(endpointMapping, webEndpoints, corsConfiguration);
        this.setOrder(-100);
    }

    @Override
    protected void registerMappingForOperation(WebEndpointOperation operation) {
        this.registerMapping(this.createRequestMappingInfo(operation), new OperationHandler(operation.getInvoker()), this.handle);
    }

    @Override
    protected Method getLinks() {
        return this.links;
    }

    @ResponseBody
    private Map<String, Map<String, Link>> links(HttpServletRequest request) {
        return Collections.singletonMap("_links", this.endpointLinksResolver.resolveLinks(this.getEndpoints(), request.getRequestURL().toString()));
    }

    final class OperationHandler {
        private final OperationInvoker operationInvoker;

        OperationHandler(OperationInvoker operationInvoker) {
            this.operationInvoker = operationInvoker;
        }

        @ResponseBody
        public Object handle(HttpServletRequest request, @RequestBody(required=false) Map<String, String> body) {
            HashMap<String, Object> arguments = new HashMap<String, Object>((Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE));
            HttpMethod httpMethod = HttpMethod.valueOf((String)request.getMethod());
            if (body != null && HttpMethod.POST == httpMethod) {
                arguments.putAll(body);
            }
            request.getParameterMap().forEach((name, values) -> arguments.put((String)name, ((String[])values).length == 1 ? values[0] : Arrays.asList(values)));
            try {
                return this.handleResult(this.operationInvoker.invoke(arguments), httpMethod);
            }
            catch (ParameterMappingException | ParametersMissingException ex) {
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
        }

        private Object handleResult(Object result, HttpMethod httpMethod) {
            if (result == null) {
                return new ResponseEntity(httpMethod == HttpMethod.GET ? HttpStatus.NOT_FOUND : HttpStatus.NO_CONTENT);
            }
            if (!(result instanceof WebEndpointResponse)) {
                return result;
            }
            WebEndpointResponse response = (WebEndpointResponse)result;
            return new ResponseEntity(response.getBody(), HttpStatus.valueOf((int)response.getStatus()));
        }
    }
}

