/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.integration;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.PollableChannelManagement;

public class SpringIntegrationMetrics
implements MeterBinder,
SmartInitializingSingleton {
    private final Iterable<Tag> tags;
    private Collection<MeterRegistry> registries = new ArrayList<MeterRegistry>();
    private final IntegrationManagementConfigurer configurer;

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer) {
        this(configurer, Collections.emptyList());
    }

    public SpringIntegrationMetrics(IntegrationManagementConfigurer configurer, Iterable<Tag> tags) {
        this.configurer = configurer;
        this.tags = tags;
    }

    public void bindTo(MeterRegistry registry) {
        this.bindChannelNames(registry);
        this.bindHandlerNames(registry);
        this.bindSourceNames(registry);
        this.registries.add(registry);
    }

    private void bindChannelNames(MeterRegistry registry) {
        Meter.Id id = registry.createId("spring.integration.channelNames", this.tags, "The number of spring integration channels");
        registry.gauge(id, (Object)this.configurer, c -> c.getChannelNames().length);
    }

    private void bindHandlerNames(MeterRegistry registry) {
        Meter.Id id = registry.createId("spring.integration.handlerNames", this.tags, "The number of spring integration handlers");
        registry.gauge(id, (Object)this.configurer, c -> c.getHandlerNames().length);
    }

    private void bindSourceNames(MeterRegistry registry) {
        Meter.Id id = registry.createId("spring.integration.sourceNames", this.tags, "The number of spring integration sources");
        registry.gauge(id, (Object)this.configurer, c -> c.getSourceNames().length);
    }

    private void addSourceMetrics(MeterRegistry registry) {
        for (String sourceName : this.configurer.getSourceNames()) {
            this.addSourceMetrics(registry, sourceName);
        }
    }

    private void addSourceMetrics(MeterRegistry registry, String sourceName) {
        MessageSourceMetrics sourceMetrics = this.configurer.getSourceMetrics(sourceName);
        Iterable tags = Tags.concat(this.tags, (String[])new String[]{"source", sourceName});
        Meter.Id id = registry.createId("spring.integration.source.messages", tags, "The number of successful handler calls");
        registry.more().counter(id, (Object)sourceMetrics, MessageSourceMetrics::getMessageCount);
    }

    private void addHandlerMetrics(MeterRegistry registry) {
        for (String handler : this.configurer.getHandlerNames()) {
            this.addHandlerMetrics(registry, handler);
        }
    }

    private void addHandlerMetrics(MeterRegistry registry, String handler) {
        MessageHandlerMetrics handlerMetrics = this.configurer.getHandlerMetrics(handler);
        Iterable tags = Tags.concat(this.tags, (String[])new String[]{"handler", handler});
        this.addDurationMax(registry, handlerMetrics, tags);
        this.addDurationMin(registry, handlerMetrics, tags);
        this.addDurationMean(registry, handlerMetrics, tags);
        this.addActiveCount(registry, handlerMetrics, tags);
    }

    private void addDurationMax(MeterRegistry registry, MessageHandlerMetrics handlerMetrics, Iterable<Tag> tags) {
        Meter.Id id = registry.createId("spring.integration.handler.duration.max", tags, "The maximum handler duration");
        registry.more().timeGauge(id, (Object)handlerMetrics, TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMaxDuration);
    }

    private void addDurationMin(MeterRegistry registry, MessageHandlerMetrics handlerMetrics, Iterable<Tag> tags) {
        Meter.Id id = registry.createId("spring.integration.handler.duration.min", tags, "The minimum handler duration");
        registry.more().timeGauge(id, (Object)handlerMetrics, TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMinDuration);
    }

    private void addDurationMean(MeterRegistry registry, MessageHandlerMetrics handlerMetrics, Iterable<Tag> tags) {
        Meter.Id id = registry.createId("spring.integration.handler.duration.mean", tags, "The mean handler duration");
        registry.more().timeGauge(id, (Object)handlerMetrics, TimeUnit.MILLISECONDS, MessageHandlerMetrics::getMeanDuration);
    }

    private void addActiveCount(MeterRegistry registry, MessageHandlerMetrics handlerMetrics, Iterable<Tag> tags) {
        Meter.Id id = registry.createId("spring.integration.handler.activeCount", tags, "The number of active handlers");
        registry.gauge(id, (Object)handlerMetrics, MessageHandlerMetrics::getActiveCount);
    }

    private void addChannelMetrics(MeterRegistry registry) {
        for (String channel : this.configurer.getChannelNames()) {
            this.addChannelMetrics(registry, channel);
        }
    }

    private void addChannelMetrics(MeterRegistry registry, String channel) {
        Iterable tags = Tags.concat(this.tags, (String[])new String[]{"channel", channel});
        MessageChannelMetrics channelMetrics = this.configurer.getChannelMetrics(channel);
        this.addSendErrors(registry, tags, channelMetrics);
        this.addChannelSends(registry, tags, channelMetrics);
        if (channelMetrics instanceof PollableChannelManagement) {
            this.addReceives(registry, tags, channelMetrics);
        }
    }

    private void addSendErrors(MeterRegistry registry, Iterable<Tag> tags, MessageChannelMetrics channelMetrics) {
        Meter.Id id = registry.createId("spring.integration.channel.sendErrors", tags, "The number of failed sends (either throwing an exception or rejected by the channel)");
        registry.more().counter(id, (Object)channelMetrics, MessageChannelMetrics::getSendErrorCount);
    }

    private void addReceives(MeterRegistry registry, Iterable<Tag> tags, MessageChannelMetrics channelMetrics) {
        Meter.Id id = registry.createId("spring.integration.channel.receives", tags, "The number of messages received");
        registry.more().counter(id, (Object)((PollableChannelManagement)channelMetrics), PollableChannelManagement::getReceiveCount);
    }

    private void addChannelSends(MeterRegistry registry, Iterable<Tag> tags, MessageChannelMetrics channelMetrics) {
        Meter.Id id = registry.createId("spring.integration.channel.sends", tags, "The number of successful sends");
        registry.more().counter(id, (Object)channelMetrics, MessageChannelMetrics::getSendCount);
    }

    public void afterSingletonsInstantiated() {
        this.registries.forEach(registry -> {
            this.addChannelMetrics((MeterRegistry)registry);
            this.addHandlerMetrics((MeterRegistry)registry);
            this.addSourceMetrics((MeterRegistry)registry);
        });
    }
}

