/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.ParameterMapper;
import org.springframework.boot.actuate.endpoint.ReflectiveOperationInvoker;
import org.springframework.boot.actuate.endpoint.annotation.AnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.boot.actuate.endpoint.cache.CachingOperationInvoker;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperation;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperationParameterInfo;
import org.springframework.boot.actuate.endpoint.jmx.annotation.JmxEndpointExtension;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.metadata.ManagedOperation;
import org.springframework.jmx.export.metadata.ManagedOperationParameter;
import org.springframework.util.StringUtils;

public class JmxAnnotationEndpointDiscoverer
extends AnnotationEndpointDiscoverer<JmxEndpointOperation, String> {
    private static final AnnotationJmxAttributeSource jmxAttributeSource = new AnnotationJmxAttributeSource();

    public JmxAnnotationEndpointDiscoverer(ApplicationContext applicationContext, ParameterMapper parameterMapper, CachingConfigurationFactory cachingConfigurationFactory) {
        super(applicationContext, new JmxEndpointOperationFactory(parameterMapper), JmxEndpointOperation::getOperationName, cachingConfigurationFactory);
    }

    @Override
    public Collection<EndpointInfo<JmxEndpointOperation>> discoverEndpoints() {
        Collection<AnnotationEndpointDiscoverer.EndpointInfoDescriptor<JmxEndpointOperation, String>> endpointDescriptors = this.discoverEndpoints(JmxEndpointExtension.class, EndpointExposure.JMX);
        this.verifyThatOperationsHaveDistinctName(endpointDescriptors);
        return endpointDescriptors.stream().map(AnnotationEndpointDiscoverer.EndpointInfoDescriptor::getEndpointInfo).collect(Collectors.toList());
    }

    private void verifyThatOperationsHaveDistinctName(Collection<AnnotationEndpointDiscoverer.EndpointInfoDescriptor<JmxEndpointOperation, String>> endpointDescriptors) {
        ArrayList clashes = new ArrayList();
        endpointDescriptors.forEach(descriptor -> clashes.addAll(descriptor.findDuplicateOperations().values()));
        if (!clashes.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("Found multiple JMX operations with the same name:%n", new Object[0]));
            clashes.forEach(clash -> {
                message.append("    ").append(((JmxEndpointOperation)clash.get(0)).getOperationName()).append(String.format(":%n", new Object[0]));
                clash.forEach(operation -> message.append("        ").append(String.format("%s%n", operation)));
            });
            throw new IllegalStateException(message.toString());
        }
    }

    private static class JmxEndpointOperationFactory
    implements AnnotationEndpointDiscoverer.EndpointOperationFactory<JmxEndpointOperation> {
        private final ParameterMapper parameterMapper;

        JmxEndpointOperationFactory(ParameterMapper parameterMapper) {
            this.parameterMapper = parameterMapper;
        }

        @Override
        public JmxEndpointOperation createOperation(String endpointId, AnnotationAttributes operationAttributes, Object target, Method method, OperationType type, long timeToLive) {
            ReflectiveOperationInvoker invoker = new ReflectiveOperationInvoker(target, method, this.parameterMapper);
            String operationName = method.getName();
            Class<?> outputType = this.getJmxType(method.getReturnType());
            String description = this.getDescription(method, () -> "Invoke " + operationName + " for endpoint " + endpointId);
            List<JmxEndpointOperationParameterInfo> parameters = this.getParameters(invoker);
            return new JmxEndpointOperation(type, CachingOperationInvoker.apply(invoker, timeToLive), operationName, outputType, description, parameters);
        }

        private String getDescription(Method method, Supplier<String> fallback) {
            ManagedOperation managedOperation = jmxAttributeSource.getManagedOperation(method);
            if (managedOperation != null && StringUtils.hasText((String)managedOperation.getDescription())) {
                return managedOperation.getDescription();
            }
            return fallback.get();
        }

        private List<JmxEndpointOperationParameterInfo> getParameters(ReflectiveOperationInvoker invoker) {
            if (invoker.getMethod().getParameterCount() == 0) {
                return Collections.emptyList();
            }
            ManagedOperationParameter[] operationParameters = jmxAttributeSource.getManagedOperationParameters(invoker.getMethod());
            if (operationParameters.length == 0) {
                return invoker.getParameters(this::getParameter);
            }
            return this.mergeParameters(invoker.getMethod().getParameters(), operationParameters);
        }

        private List<JmxEndpointOperationParameterInfo> mergeParameters(Parameter[] methodParameters, ManagedOperationParameter[] operationParameters) {
            ArrayList<JmxEndpointOperationParameterInfo> parameters = new ArrayList<JmxEndpointOperationParameterInfo>();
            for (int i = 0; i < operationParameters.length; ++i) {
                ManagedOperationParameter operationParameter = operationParameters[i];
                Parameter methodParameter = methodParameters[i];
                JmxEndpointOperationParameterInfo parameter = this.getParameter(operationParameter.getName(), methodParameter, operationParameter.getDescription());
                parameters.add(parameter);
            }
            return parameters;
        }

        private JmxEndpointOperationParameterInfo getParameter(String name, Parameter methodParameter) {
            return this.getParameter(name, methodParameter, null);
        }

        private JmxEndpointOperationParameterInfo getParameter(String name, Parameter methodParameter, String description) {
            return new JmxEndpointOperationParameterInfo(name, this.getJmxType(methodParameter.getType()), description);
        }

        private Class<?> getJmxType(Class<?> type) {
            if (type.isEnum()) {
                return String.class;
            }
            if (Date.class.isAssignableFrom(type)) {
                return String.class;
            }
            if (type.getName().startsWith("java.")) {
                return type;
            }
            if (type.equals(Void.TYPE)) {
                return type;
            }
            return Object.class;
        }
    }
}

