/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.info;

import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.DefaultEnablement;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.util.Assert;

@Endpoint(id="info", defaultEnablement=DefaultEnablement.ENABLED)
public class InfoEndpoint {
    private final List<InfoContributor> infoContributors;

    public InfoEndpoint(List<InfoContributor> infoContributors) {
        Assert.notNull(infoContributors, (String)"Info contributors must not be null");
        this.infoContributors = infoContributors;
    }

    @ReadOperation
    public Map<String, Object> info() {
        Info.Builder builder = new Info.Builder();
        for (InfoContributor contributor : this.infoContributors) {
            contributor.contribute(builder);
        }
        Info build = builder.build();
        return build.getDetails();
    }
}

