/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.metrics.web.reactive.server.WebFluxTagsProvider;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class MetricsWebFilter
implements WebFilter {
    private final MeterRegistry registry;
    private final WebFluxTagsProvider tagsProvider;
    private final String metricName;

    public MetricsWebFilter(MeterRegistry registry, WebFluxTagsProvider tagsProvider, String metricName) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).compose(call -> this.filter(exchange, (Mono<Void>)call));
    }

    private Publisher<Void> filter(ServerWebExchange exchange, Mono<Void> call) {
        long start = System.nanoTime();
        return call.doOnSuccess(done -> this.success(exchange, start)).doOnError(cause -> this.error(exchange, start, (Throwable)cause));
    }

    private void success(ServerWebExchange exchange, long start) {
        Iterable<Tag> tags = this.tagsProvider.httpRequestTags(exchange, null);
        this.registry.timer(this.metricName, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }

    private void error(ServerWebExchange exchange, long start, Throwable cause) {
        Iterable<Tag> tags = this.tagsProvider.httpRequestTags(exchange, cause);
        this.registry.timer(this.metricName, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }
}

