/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;

public class RouterFunctionMetrics {
    private final MeterRegistry registry;
    private BiFunction<ServerRequest, ServerResponse, Collection<Tag>> defaultTags = (request, response) -> response != null ? Arrays.asList(RouterFunctionMetrics.method(request), RouterFunctionMetrics.status(response)) : Collections.singletonList(RouterFunctionMetrics.method(request));

    public RouterFunctionMetrics(MeterRegistry registry) {
        this.registry = registry;
    }

    public RouterFunctionMetrics defaultTags(BiFunction<ServerRequest, ServerResponse, Collection<Tag>> defaultTags) {
        this.defaultTags = defaultTags;
        return this;
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name) {
        return this.timer(name, Collections.emptyList());
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name, String ... tags) {
        return this.timer(name, Tags.zip((String[])tags));
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name, Iterable<Tag> tags) {
        return (request, next) -> {
            long start = System.nanoTime();
            return next.handle(request).doOnSuccess(response -> {
                Iterable allTags = Tags.concat((Iterable)tags, (Iterable)this.defaultTags.apply(request, (ServerResponse)response));
                this.registry.timer(name, allTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }).doOnError(error -> {
                Iterable allTags = Tags.concat((Iterable)tags, (Iterable)this.defaultTags.apply(request, null));
                this.registry.timer(name, allTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            });
        };
    }

    public static Tag method(ServerRequest request) {
        return Tag.of((String)"method", (String)request.method().toString());
    }

    public static Tag status(ServerResponse response) {
        return Tag.of((String)"status", (String)response.statusCode().toString());
    }
}

