/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcMetrics;
import org.springframework.core.annotation.Order;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.util.NestedServletException;

@Order(value=-2147483648)
public class WebMvcMetricsFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(WebMvcMetricsFilter.class);
    private final WebMvcMetrics webMvcMetrics;
    private final HandlerMappingIntrospector mappingIntrospector;

    public WebMvcMetricsFilter(WebMvcMetrics webMvcMetrics, HandlerMappingIntrospector mappingIntrospector) {
        this.webMvcMetrics = webMvcMetrics;
        this.mappingIntrospector = mappingIntrospector;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HandlerExecutionChain handlerExecutionChain = this.getHandlerExecutionChain(request);
        Object handler = handlerExecutionChain == null ? null : handlerExecutionChain.getHandler();
        this.filterWithMetrics(request, response, filterChain, handler);
    }

    private HandlerExecutionChain getHandlerExecutionChain(HttpServletRequest request) {
        try {
            MatchableHandlerMapping matchableHandlerMapping = this.mappingIntrospector.getMatchableHandlerMapping(request);
            return matchableHandlerMapping == null ? null : matchableHandlerMapping.getHandler(request);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to time request", (Throwable)ex);
            }
            return null;
        }
    }

    private void filterWithMetrics(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain, Object handler) throws IOException, ServletException, NestedServletException {
        this.webMvcMetrics.preHandle(request, handler);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (!request.isAsyncStarted()) {
                this.webMvcMetrics.record(request, response, null);
            }
        }
        catch (NestedServletException ex) {
            this.webMvcMetrics.record(request, response, ex.getCause());
            throw ex;
        }
    }
}

