/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.audit;

import java.util.Date;
import java.util.List;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.util.Assert;

@Endpoint(id="auditevents")
public class AuditEventsEndpoint {
    private final AuditEventRepository auditEventRepository;

    public AuditEventsEndpoint(AuditEventRepository auditEventRepository) {
        Assert.notNull((Object)auditEventRepository, (String)"AuditEventRepository must not be null");
        this.auditEventRepository = auditEventRepository;
    }

    @ReadOperation
    public AuditEventsDescriptor eventsWithPrincipalDateAfterAndType(String principal, Date after, String type) {
        return new AuditEventsDescriptor(this.auditEventRepository.find(principal, after, type));
    }

    public static final class AuditEventsDescriptor {
        private final List<AuditEvent> events;

        private AuditEventsDescriptor(List<AuditEvent> events) {
            this.events = events;
        }

        public List<AuditEvent> getEvents() {
            return this.events;
        }
    }
}

