/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.couchbase;

import java.util.Collection;
import java.util.List;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CouchbaseHealthIndicator
extends AbstractHealthIndicator {
    private CouchbaseOperations couchbaseOperations;

    public CouchbaseHealthIndicator(CouchbaseOperations couchbaseOperations) {
        Assert.notNull((Object)couchbaseOperations, (String)"CouchbaseOperations must not be null");
        this.couchbaseOperations = couchbaseOperations;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        List versions = this.couchbaseOperations.getCouchbaseClusterInfo().getAllVersions();
        builder.up().withDetail("versions", StringUtils.collectionToCommaDelimitedString((Collection)versions));
    }
}

