/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoke.convert;

import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.boot.actuate.endpoint.invoke.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.invoke.convert.IsoOffsetDateTimeConverter;
import org.springframework.boot.context.properties.bind.convert.BinderConversionService;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;

public class ConversionServiceParameterValueMapper
implements ParameterValueMapper {
    private final ConversionService conversionService;

    public ConversionServiceParameterValueMapper() {
        this(ConversionServiceParameterValueMapper.createConversionService());
    }

    public ConversionServiceParameterValueMapper(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = new BinderConversionService(conversionService);
    }

    @Override
    public Object mapParameterValue(OperationParameter parameter, Object value) throws ParameterMappingException {
        try {
            return this.conversionService.convert(value, parameter.getType());
        }
        catch (Exception ex) {
            throw new ParameterMappingException(parameter, value, (Throwable)ex);
        }
    }

    private static ConversionService createConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        IsoOffsetDateTimeConverter.registerConverter((ConverterRegistry)conversionService);
        return conversionService;
    }
}

