/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoke.reflect;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.invoke.MissingParametersException;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.invoke.reflect.OperationMethod;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ReflectiveOperationInvoker
implements OperationInvoker {
    private final Object target;
    private final OperationMethod operationMethod;
    private final ParameterValueMapper parameterValueMapper;

    public ReflectiveOperationInvoker(Object target, OperationMethod operationMethod, ParameterValueMapper parameterValueMapper) {
        Assert.notNull((Object)target, (String)"Target must not be null");
        Assert.notNull((Object)operationMethod, (String)"OperationMethod must not be null");
        Assert.notNull((Object)parameterValueMapper, (String)"ParameterValueMapper must not be null");
        ReflectionUtils.makeAccessible((Method)operationMethod.getMethod());
        this.target = target;
        this.operationMethod = operationMethod;
        this.parameterValueMapper = parameterValueMapper;
    }

    @Override
    public Object invoke(Map<String, Object> arguments) {
        this.validateRequiredParameters(arguments);
        Method method = this.operationMethod.getMethod();
        Object[] resolvedArguments = this.resolveArguments(arguments);
        ReflectionUtils.makeAccessible((Method)method);
        return ReflectionUtils.invokeMethod((Method)method, (Object)this.target, (Object[])resolvedArguments);
    }

    private void validateRequiredParameters(Map<String, Object> arguments) {
        Set<OperationParameter> missing = this.operationMethod.getParameters().stream().filter(parameter -> this.isMissing(arguments, (OperationParameter)parameter)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            throw new MissingParametersException(missing);
        }
    }

    private boolean isMissing(Map<String, Object> arguments, OperationParameter parameter) {
        if (parameter.isNullable()) {
            return false;
        }
        return arguments.get(parameter.getName()) == null;
    }

    private Object[] resolveArguments(Map<String, Object> arguments) {
        return this.operationMethod.getParameters().stream().map(parameter -> this.resolveArgument((OperationParameter)parameter, arguments)).toArray();
    }

    private Object resolveArgument(OperationParameter parameter, Map<String, Object> arguments) {
        Object value = arguments.get(parameter.getName());
        return this.parameterValueMapper.mapParameterValue(parameter, value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("target", this.target).append("method", (Object)this.operationMethod).toString();
    }
}

