/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.servlet;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.InvalidEndpointRequestException;
import org.springframework.boot.actuate.endpoint.InvocationContext;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.servlet.SkipPathExtensionContentNegotiation;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public abstract class AbstractWebMvcEndpointHandlerMapping
extends RequestMappingInfoHandlerMapping
implements InitializingBean {
    private final EndpointMapping endpointMapping;
    private final Collection<ExposableWebEndpoint> endpoints;
    private final EndpointMediaTypes endpointMediaTypes;
    private final CorsConfiguration corsConfiguration;
    private final Method linksMethod = ReflectionUtils.findMethod(((Object)((Object)this)).getClass(), (String)"links", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
    private final Method handleMethod = ReflectionUtils.findMethod(OperationHandler.class, (String)"handle", (Class[])new Class[]{HttpServletRequest.class, Map.class});

    public AbstractWebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes) {
        this(endpointMapping, endpoints, endpointMediaTypes, null);
    }

    public AbstractWebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration) {
        this.endpointMapping = endpointMapping;
        this.endpoints = endpoints;
        this.endpointMediaTypes = endpointMediaTypes;
        this.corsConfiguration = corsConfiguration;
        this.setOrder(-100);
    }

    protected void initHandlerMethods() {
        for (ExposableWebEndpoint endpoint : this.endpoints) {
            for (WebOperation operation : endpoint.getOperations()) {
                this.registerMappingForOperation(endpoint, operation);
            }
        }
        if (StringUtils.hasText((String)this.endpointMapping.getPath())) {
            this.registerLinksMapping();
        }
    }

    private void registerMappingForOperation(ExposableWebEndpoint endpoint, WebOperation operation) {
        OperationInvoker invoker = operation::invoke;
        ServletWebOperation servletWebOperation = this.wrapServletWebOperation(endpoint, operation, new ServletWebOperationAdapter(invoker));
        this.registerMapping(this.createRequestMappingInfo(operation), new OperationHandler(servletWebOperation), this.handleMethod);
    }

    protected ServletWebOperation wrapServletWebOperation(ExposableWebEndpoint endpoint, WebOperation operation, ServletWebOperation servletWebOperation) {
        return servletWebOperation;
    }

    private RequestMappingInfo createRequestMappingInfo(WebOperation operation) {
        WebOperationRequestPredicate predicate = operation.getRequestPredicate();
        PatternsRequestCondition patterns = this.patternsRequestConditionForPattern(predicate.getPath());
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.valueOf((String)predicate.getHttpMethod().name())});
        ConsumesRequestCondition consumes = new ConsumesRequestCondition(this.toStringArray(predicate.getConsumes()));
        ProducesRequestCondition produces = new ProducesRequestCondition(this.toStringArray(predicate.getProduces()));
        return new RequestMappingInfo(null, patterns, methods, null, null, consumes, produces, null);
    }

    private String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private void registerLinksMapping() {
        PatternsRequestCondition patterns = this.patternsRequestConditionForPattern("");
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.GET});
        ProducesRequestCondition produces = new ProducesRequestCondition(this.endpointMediaTypes.getProduced().toArray(new String[this.endpointMediaTypes.getProduced().size()]));
        RequestMappingInfo mapping = new RequestMappingInfo(patterns, methods, null, null, null, produces, null);
        this.registerMapping(mapping, (Object)this, this.linksMethod);
    }

    private PatternsRequestCondition patternsRequestConditionForPattern(String path) {
        String[] patterns = new String[]{this.endpointMapping.createSubPath(path)};
        return new PatternsRequestCondition(patterns, null, null, false, true);
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mapping) {
        return this.corsConfiguration;
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        interceptors.add((Object)new SkipPathExtensionContentNegotiation());
    }

    protected abstract Object links(HttpServletRequest var1, HttpServletResponse var2);

    public Collection<ExposableWebEndpoint> getEndpoints() {
        return this.endpoints;
    }

    private static final class ServletSecurityContext
    implements SecurityContext {
        private final HttpServletRequest request;

        private ServletSecurityContext(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public Principal getPrincipal() {
            return this.request.getUserPrincipal();
        }

        @Override
        public boolean isUserInRole(String role) {
            return this.request.isUserInRole(role);
        }
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    private static class BadOperationRequestException
    extends RuntimeException {
        BadOperationRequestException(String message) {
            super(message);
        }
    }

    private final class OperationHandler {
        private final ServletWebOperation operation;

        OperationHandler(ServletWebOperation operation) {
            this.operation = operation;
        }

        @ResponseBody
        public Object handle(HttpServletRequest request, @RequestBody(required=false) Map<String, String> body) {
            return this.operation.handle(request, body);
        }
    }

    private class ServletWebOperationAdapter
    implements ServletWebOperation {
        private final OperationInvoker invoker;

        ServletWebOperationAdapter(OperationInvoker invoker) {
            this.invoker = invoker;
        }

        @Override
        public Object handle(HttpServletRequest request, @RequestBody(required=false) Map<String, String> body) {
            Map<String, Object> arguments = this.getArguments(request, body);
            try {
                return this.handleResult(this.invoker.invoke(new InvocationContext(new ServletSecurityContext(request), arguments)), HttpMethod.valueOf((String)request.getMethod()));
            }
            catch (InvalidEndpointRequestException ex) {
                throw new BadOperationRequestException(ex.getReason());
            }
        }

        private Map<String, Object> getArguments(HttpServletRequest request, Map<String, String> body) {
            LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>();
            arguments.putAll(this.getTemplateVariables(request));
            if (body != null && HttpMethod.POST.name().equals(request.getMethod())) {
                arguments.putAll(body);
            }
            request.getParameterMap().forEach((name, values) -> arguments.put((String)name, ((String[])values).length == 1 ? values[0] : Arrays.asList(values)));
            return arguments;
        }

        private Map<String, String> getTemplateVariables(HttpServletRequest request) {
            return (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        }

        private Object handleResult(Object result, HttpMethod httpMethod) {
            if (result == null) {
                return new ResponseEntity(httpMethod == HttpMethod.GET ? HttpStatus.NOT_FOUND : HttpStatus.NO_CONTENT);
            }
            if (!(result instanceof WebEndpointResponse)) {
                return result;
            }
            WebEndpointResponse response = (WebEndpointResponse)result;
            return new ResponseEntity(response.getBody(), HttpStatus.valueOf((int)response.getStatus()));
        }
    }

    @FunctionalInterface
    protected static interface ServletWebOperation {
        public Object handle(HttpServletRequest var1, Map<String, String> var2);
    }
}

