/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.couchbase;

import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.cluster.ClusterInfo;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CouchbaseHealthIndicator
extends AbstractHealthIndicator {
    private final CouchbaseOperations operations;
    private final long timeout;

    public CouchbaseHealthIndicator(CouchbaseOperations couchbaseOperations, Duration timeout) {
        super("Couchbase health check failed");
        Assert.notNull((Object)couchbaseOperations, (String)"CouchbaseOperations must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        this.operations = couchbaseOperations;
        this.timeout = timeout.toMillis();
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        ClusterInfo cluster = this.operations.getCouchbaseClusterInfo();
        BucketInfo bucket = this.getBucketInfo();
        String versions = StringUtils.collectionToCommaDelimitedString((Collection)cluster.getAllVersions());
        String nodes = StringUtils.collectionToCommaDelimitedString((Collection)bucket.nodeList());
        builder.up().withDetail("versions", versions).withDetail("nodes", nodes);
    }

    private BucketInfo getBucketInfo() throws Exception {
        try {
            return this.operations.getCouchbaseBucket().bucketManager().info(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof TimeoutException) {
                throw (TimeoutException)ex.getCause();
            }
            throw ex;
        }
    }
}

