/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.HealthContributorRegistry;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HealthEndpointSupport;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.StatusAggregator;

@Endpoint(id="health")
public class HealthEndpoint
extends HealthEndpointSupport<HealthContributor, HealthComponent> {
    private static final String[] EMPTY_PATH = new String[0];

    @Deprecated
    public HealthEndpoint(HealthIndicator healthIndicator) {
    }

    public HealthEndpoint(HealthContributorRegistry registry, HealthEndpointGroups groups) {
        super(registry, groups);
    }

    @ReadOperation
    public HealthComponent health() {
        return this.healthForPath(EMPTY_PATH);
    }

    @ReadOperation
    public HealthComponent healthForPath(String ... path) {
        HealthEndpointSupport.HealthResult result = this.getHealth(SecurityContext.NONE, true, path);
        return result != null ? (HealthComponent)result.getHealth() : null;
    }

    @Override
    protected HealthComponent getHealth(HealthContributor contributor, boolean includeDetails) {
        return ((HealthIndicator)contributor).getHealth(includeDetails);
    }

    @Override
    protected HealthComponent aggregateContributions(Map<String, HealthComponent> contributions, StatusAggregator statusAggregator, boolean includeDetails, Set<String> groupNames) {
        return this.getCompositeHealth(contributions, statusAggregator, includeDetails, groupNames);
    }
}

