/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.invoke.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class OperationMethodParameter
implements OperationParameter {
    private static final boolean jsr305Present = ClassUtils.isPresent((String)"javax.annotation.Nonnull", null);
    private final String name;
    private final Parameter parameter;
    private final Predicate<Parameter> optional;

    OperationMethodParameter(String name, Parameter parameter, Predicate<Parameter> optionalParameters) {
        this.name = name;
        this.parameter = parameter;
        this.optional = optionalParameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.parameter.getType();
    }

    @Override
    public boolean isMandatory() {
        if (this.isOptional()) {
            return false;
        }
        if (jsr305Present) {
            return new Jsr305().isMandatory(this.parameter);
        }
        return true;
    }

    private boolean isOptional() {
        return ((Nullable[])this.parameter.getAnnotationsByType(Nullable.class)).length > 0 || this.optional.test(this.parameter);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.parameter.getAnnotation(annotation);
    }

    public String toString() {
        return this.name + " of type " + this.parameter.getType().getName();
    }

    private static final class Jsr305 {
        private Jsr305() {
        }

        boolean isMandatory(Parameter parameter) {
            MergedAnnotation annotation = MergedAnnotations.from((AnnotatedElement)parameter).get(Nonnull.class);
            return !annotation.isPresent() || annotation.getEnum("when", When.class) == When.ALWAYS;
        }
    }
}

