/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.stereotype.Component;

@Component
public class BatchDatabaseInitializer
implements EnvironmentAware {
    private static final String DEFAULT_SCHEMA_LOCATION = "classpath:org/springframework/batch/core/schema-@@platform@@.sql";
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ResourceLoader resourceLoader;
    private RelaxedPropertyResolver environment;

    public void setEnvironment(Environment environment) {
        this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.batch.");
    }

    @PostConstruct
    protected void initialize() throws Exception {
        String platform = DatabaseType.fromMetaData((DataSource)this.dataSource).toString().toLowerCase();
        if ("hsql".equals(platform)) {
            platform = "hsqldb";
        }
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        String schemaLocation = this.environment.getProperty("schema", DEFAULT_SCHEMA_LOCATION);
        schemaLocation = schemaLocation.replace("@@platform@@", platform);
        populator.addScript(this.resourceLoader.getResource(schemaLocation));
        populator.setContinueOnError(true);
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
    }
}

