/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

class OnBeanCondition
extends SpringBootCondition
implements ConfigurationCondition {
    private static final String[] NO_BEANS = new String[0];

    OnBeanCondition() {
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }

    @Override
    public SpringBootCondition.Outcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        BeanSearchSpec spec;
        List<String> matching;
        if (metadata.isAnnotated(ConditionalOnBean.class.getName()) && (matching = this.getMatchingBeans(context, spec = new BeanSearchSpec(context, metadata, ConditionalOnBean.class))).isEmpty()) {
            return SpringBootCondition.Outcome.noMatch("@ConditionalOnBean " + spec + " found no beans");
        }
        if (metadata.isAnnotated(ConditionalOnMissingBean.class.getName()) && !(matching = this.getMatchingBeans(context, spec = new BeanSearchSpec(context, metadata, ConditionalOnMissingBean.class))).isEmpty()) {
            return SpringBootCondition.Outcome.noMatch("@ConditionalOnMissingBean " + spec + " found the following " + matching);
        }
        return SpringBootCondition.Outcome.match();
    }

    private List<String> getMatchingBeans(ConditionContext context, BeanSearchSpec beans) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beans.getStrategy() == SearchStrategy.PARENTS) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)parent, (String)"Unable to use SearchStrategy.PARENTS");
            beanFactory = (ConfigurableListableBeanFactory)parent;
        }
        ArrayList<String> beanNames = new ArrayList<String>();
        boolean considerHierarchy = beans.getStrategy() == SearchStrategy.ALL;
        for (String type : beans.getTypes()) {
            beanNames.addAll(Arrays.asList(this.getBeanNamesForType(beanFactory, type, context.getClassLoader(), considerHierarchy)));
        }
        for (String beanName : beans.getNames()) {
            if (!this.containsBean(beanFactory, beanName, considerHierarchy)) continue;
            beanNames.add(beanName);
        }
        return beanNames;
    }

    private boolean containsBean(ConfigurableListableBeanFactory beanFactory, String beanName, boolean considerHierarchy) {
        if (considerHierarchy) {
            return beanFactory.containsBean(beanName);
        }
        return beanFactory.containsLocalBean(beanName);
    }

    private String[] getBeanNamesForType(ConfigurableListableBeanFactory beanFactory, String type, ClassLoader classLoader, boolean considerHierarchy) throws LinkageError {
        try {
            Class typeClass = ClassUtils.forName((String)type, (ClassLoader)classLoader);
            if (considerHierarchy) {
                return BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, (Class)typeClass, (boolean)false, (boolean)false);
            }
            return beanFactory.getBeanNamesForType(typeClass, false, false);
        }
        catch (ClassNotFoundException ex) {
            return NO_BEANS;
        }
    }

    private static class BeanSearchSpec {
        private List<String> names = new ArrayList<String>();
        private List<String> types = new ArrayList<String>();
        private SearchStrategy strategy;

        public BeanSearchSpec(ConditionContext context, AnnotatedTypeMetadata metadata, Class<?> annotationType) {
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(annotationType.getName(), true);
            this.collect((MultiValueMap<String, Object>)attributes, "name", this.names);
            this.collect((MultiValueMap<String, Object>)attributes, "value", this.types);
            if (this.types.isEmpty() && this.names.isEmpty()) {
                this.addDeducedBeanType(context, metadata, this.types);
            }
            Assert.isTrue((!this.types.isEmpty() || !this.names.isEmpty() ? 1 : 0) != 0, (String)("@" + ClassUtils.getShortName(annotationType) + " annotations must specify at least one bean"));
            this.strategy = (SearchStrategy)((Object)metadata.getAnnotationAttributes(annotationType.getName()).get("search"));
        }

        private void collect(MultiValueMap<String, Object> attributes, String key, List<String> destination) {
            List valueList = (List)attributes.get((Object)key);
            Iterator i$ = valueList.iterator();
            while (i$.hasNext()) {
                String[] valueArray;
                for (String value : valueArray = (String[])i$.next()) {
                    destination.add(value);
                }
            }
        }

        private void addDeducedBeanType(ConditionContext context, AnnotatedTypeMetadata metadata, final List<String> beanTypes) {
            if (metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName())) {
                try {
                    final MethodMetadata methodMetadata = (MethodMetadata)metadata;
                    Class configClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), (ClassLoader)context.getClassLoader());
                    ReflectionUtils.doWithMethods((Class)configClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                            if (methodMetadata.getMethodName().equals(method.getName())) {
                                beanTypes.add(method.getReturnType().getName());
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }

        public SearchStrategy getStrategy() {
            return this.strategy != null ? this.strategy : SearchStrategy.ALL;
        }

        public List<String> getNames() {
            return this.names;
        }

        public List<String> getTypes() {
            return this.types;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("names", this.names).append("types", this.types).append("strategy", (Object)this.strategy).toString();
        }
    }
}

