/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.StandardServletEnvironment;

class OnWebApplicationCondition
extends SpringBootCondition {
    private static final String WEB_CONTEXT_CLASS = "org.springframework.web.context.support.GenericWebApplicationContext";

    OnWebApplicationCondition() {
    }

    @Override
    public SpringBootCondition.Outcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean webApplicationRequired = metadata.isAnnotated(ConditionalOnWebApplication.class.getName());
        SpringBootCondition.Outcome webApplication = this.isWebApplication(context, metadata);
        if (webApplicationRequired && !webApplication.isMatch()) {
            return SpringBootCondition.Outcome.noMatch(webApplication.getMessage());
        }
        if (!webApplicationRequired && webApplication.isMatch()) {
            return SpringBootCondition.Outcome.noMatch(webApplication.getMessage());
        }
        return SpringBootCondition.Outcome.match(webApplication.getMessage());
    }

    private SpringBootCondition.Outcome isWebApplication(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Object[] scopes;
        if (!ClassUtils.isPresent((String)WEB_CONTEXT_CLASS, (ClassLoader)context.getClassLoader())) {
            return SpringBootCondition.Outcome.noMatch("web application classes not found");
        }
        if (context.getBeanFactory() != null && ObjectUtils.containsElement((Object[])(scopes = context.getBeanFactory().getRegisteredScopeNames()), (Object)"session")) {
            return SpringBootCondition.Outcome.match("found web application 'session' scope");
        }
        if (context.getEnvironment() instanceof StandardServletEnvironment) {
            return SpringBootCondition.Outcome.match("found web application StandardServletEnvironment");
        }
        return SpringBootCondition.Outcome.noMatch("not a web application");
    }
}

