/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class SpringBootCondition
implements Condition {
    private final Log logger = LogFactory.getLog(this.getClass());

    public final boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Outcome result = this.getMatchOutcome(context, metadata);
        if (!result.isMatch()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.getMessage(metadata, result));
            }
            return false;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.getMessage(metadata, result));
        }
        return true;
    }

    private StringBuilder getMessage(AnnotatedTypeMetadata metadata, Outcome result) {
        StringBuilder message = new StringBuilder();
        message.append("Condition ");
        message.append(ClassUtils.getShortName(this.getClass()));
        message.append(" on ");
        if (metadata instanceof ClassMetadata) {
            ClassMetadata classMetadata = (ClassMetadata)metadata;
            message.append(classMetadata.getClassName());
        } else if (metadata instanceof MethodMetadata) {
            MethodMetadata methodMetadata = (MethodMetadata)metadata;
            message.append(methodMetadata.getDeclaringClassName());
            message.append("#");
            message.append(methodMetadata.getMethodName());
        }
        message.append(result.isMatch() ? " matched" : "did not match");
        if (StringUtils.hasLength((String)result.getMessage())) {
            message.append(" due to ");
            message.append(result.getMessage());
        }
        return message;
    }

    public abstract Outcome getMatchOutcome(ConditionContext var1, AnnotatedTypeMetadata var2);

    protected final boolean anyMatches(ConditionContext context, AnnotatedTypeMetadata metadata, Condition ... conditions) {
        for (Condition condition : conditions) {
            if (!this.matches(context, metadata, condition)) continue;
            return true;
        }
        return false;
    }

    protected final boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata, Condition condition) {
        if (condition instanceof SpringBootCondition) {
            return ((SpringBootCondition)condition).getMatchOutcome(context, metadata).isMatch();
        }
        return condition.matches(context, metadata);
    }

    protected static final class Outcome {
        private final boolean match;
        private final String message;

        public Outcome(boolean match, String message) {
            this.match = match;
            this.message = message;
        }

        public boolean isMatch() {
            return this.match;
        }

        public String getMessage() {
            return this.message;
        }

        public static Outcome match() {
            return Outcome.match(null);
        }

        public static Outcome match(String message) {
            return new Outcome(true, message);
        }

        public static Outcome noMatch(String message) {
            return new Outcome(false, message);
        }
    }
}

