/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationUtils;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryBeanNameGenerator;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.util.Assert;

class JpaRepositoriesAutoConfigureRegistrar
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware,
BeanClassLoaderAware {
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;

    JpaRepositoriesAutoConfigureRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        AnnotationRepositoryConfigurationSource configurationSource = this.getConfigurationSource();
        JpaRepositoryConfigExtension extension = new JpaRepositoryConfigExtension();
        extension.registerBeansForRoot(registry, (RepositoryConfigurationSource)configurationSource);
        RepositoryBeanNameGenerator generator = new RepositoryBeanNameGenerator();
        generator.setBeanClassLoader(this.beanClassLoader);
        Collection repositoryConfigurations = extension.getRepositoryConfigurations((RepositoryConfigurationSource)configurationSource, (ResourceLoader)resourceLoader);
        for (RepositoryConfiguration repositoryConfiguration : repositoryConfigurations) {
            RepositoryBeanDefinitionBuilder builder = new RepositoryBeanDefinitionBuilder(repositoryConfiguration, (RepositoryConfigurationExtension)extension);
            BeanDefinitionBuilder definitionBuilder = builder.build(registry, (ResourceLoader)resourceLoader);
            extension.postProcess(definitionBuilder, configurationSource);
            String beanName = generator.generateBeanName((BeanDefinition)definitionBuilder.getBeanDefinition(), registry);
            registry.registerBeanDefinition(beanName, (BeanDefinition)definitionBuilder.getBeanDefinition());
        }
    }

    private AnnotationRepositoryConfigurationSource getConfigurationSource() {
        StandardAnnotationMetadata metadata = new StandardAnnotationMetadata(EnableJpaRepositoriesConfiguration.class, true);
        AnnotationRepositoryConfigurationSource configurationSource = new AnnotationRepositoryConfigurationSource((AnnotationMetadata)metadata, EnableJpaRepositories.class){

            public Iterable<String> getBasePackages() {
                return JpaRepositoriesAutoConfigureRegistrar.this.getBasePackages();
            }
        };
        return configurationSource;
    }

    protected Iterable<String> getBasePackages() {
        List<String> basePackages = AutoConfigurationUtils.getBasePackages(this.beanFactory);
        Assert.notEmpty(basePackages, (String)"Unable to find JPA repository base packages, please define a @ComponentScan annotation or disable JpaRepositoriesAutoConfigure");
        return basePackages;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @EnableJpaRepositories
    private static class EnableJpaRepositoriesConfiguration {
        private EnableJpaRepositoriesConfiguration() {
        }
    }
}

