/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(name="spring.datasource")
@EnableConfigurationProperties
public abstract class AbstractDataSourceConfiguration
implements BeanClassLoaderAware {
    private String driverClassName;
    private String url;
    private String username = "sa";
    private String password = "";
    private int maxActive = 100;
    private int maxIdle = 8;
    private int minIdle = 8;
    private String validationQuery;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected String getDriverClassName() {
        if (StringUtils.hasText((String)this.driverClassName)) {
            return this.driverClassName;
        }
        EmbeddedDatabaseConnection embeddedDatabaseConnection = EmbeddedDatabaseConnection.get(this.classLoader);
        this.driverClassName = embeddedDatabaseConnection.getDriverClassName();
        if (!StringUtils.hasText((String)this.driverClassName)) {
            throw new BeanCreationException("Cannot determine embedded database driver class for database type " + (Object)((Object)embeddedDatabaseConnection) + ". If you want an embedded " + "database please put a supoprted one on the classpath.");
        }
        return this.driverClassName;
    }

    protected String getUrl() {
        if (StringUtils.hasText((String)this.url)) {
            return this.url;
        }
        EmbeddedDatabaseConnection embeddedDatabaseConnection = EmbeddedDatabaseConnection.get(this.classLoader);
        this.url = embeddedDatabaseConnection.getUrl();
        if (!StringUtils.hasText((String)this.url)) {
            throw new BeanCreationException("Cannot determine embedded database url for database type " + (Object)((Object)embeddedDatabaseConnection) + ". If you want an embedded " + "database please put a supported on on the classpath.");
        }
        return this.url;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    protected int getMaxActive() {
        return this.maxActive;
    }

    protected int getMaxIdle() {
        return this.maxIdle;
    }

    protected int getMinIdle() {
        return this.minIdle;
    }

    protected String getValidationQuery() {
        return this.validationQuery;
    }

    protected boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    protected boolean isTestOnReturn() {
        return this.testOnReturn;
    }
}

