/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.Servlet;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.springsecurity3.dialect.SpringSecurityDialect;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.spring3.SpringTemplateEngine;
import org.thymeleaf.spring3.view.ThymeleafViewResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

@Configuration
@ConditionalOnClass(value={SpringTemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class ThymeleafAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={SpringSecurityDialect.class})
    protected static class ThymeleafSecurityDialectConfiguration {
        protected ThymeleafSecurityDialectConfiguration() {
        }

        @Bean
        public SpringSecurityDialect securityDialect() {
            return new SpringSecurityDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    protected static class ThymeleafViewResolverConfiguration {
        @Autowired
        private SpringTemplateEngine templateEngine;

        protected ThymeleafViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"thymeleafViewResolver"})
        public ThymeleafViewResolver thymeleafViewResolver() {
            ThymeleafViewResolver resolver = new ThymeleafViewResolver();
            resolver.setTemplateEngine(this.templateEngine);
            resolver.setCharacterEncoding("UTF-8");
            resolver.setOrder(2147483627);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnClass(name={"nz.net.ultraq.thymeleaf.LayoutDialect"})
    protected static class ThymeleafWebLayoutConfiguration {
        protected ThymeleafWebLayoutConfiguration() {
        }

        @Bean
        public LayoutDialect layoutDialect() {
            return new LayoutDialect();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringTemplateEngine.class})
    protected static class ThymeleafDefaultConfiguration {
        @Autowired
        private Collection<ITemplateResolver> templateResolvers = Collections.emptySet();
        @Autowired(required=false)
        private Collection<IDialect> dialects = Collections.emptySet();

        protected ThymeleafDefaultConfiguration() {
        }

        @Bean
        public SpringTemplateEngine templateEngine() {
            SpringTemplateEngine engine = new SpringTemplateEngine();
            for (ITemplateResolver templateResolver : this.templateResolvers) {
                engine.addTemplateResolver(templateResolver);
            }
            for (IDialect dialect : this.dialects) {
                engine.addDialect(dialect);
            }
            return engine;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(name={"defaultTemplateResolver"})
    protected static class DefaultTemplateResolverConfiguration
    implements EnvironmentAware {
        @Autowired
        private ResourceLoader resourceLoader = new DefaultResourceLoader();
        private RelaxedPropertyResolver environment;

        protected DefaultTemplateResolverConfiguration() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.thymeleaf.");
        }

        @Bean
        public ITemplateResolver defaultTemplateResolver() {
            TemplateResolver resolver = new TemplateResolver();
            resolver.setResourceResolver(new IResourceResolver(){

                public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
                    try {
                        return DefaultTemplateResolverConfiguration.this.resourceLoader.getResource(resourceName).getInputStream();
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }

                public String getName() {
                    return "SPRING";
                }
            });
            resolver.setPrefix(this.environment.getProperty("prefix", "classpath:/templates/"));
            resolver.setSuffix(this.environment.getProperty("suffix", ".html"));
            resolver.setTemplateMode(this.environment.getProperty("mode", "HTML5"));
            resolver.setCacheable(((Boolean)this.environment.getProperty("cache", Boolean.class, (Object)true)).booleanValue());
            return resolver;
        }
    }
}

