/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.util.Arrays;
import javax.servlet.Servlet;
import org.apache.catalina.startup.Tomcat;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Loader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizerBeanPostProcessor;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.servlet.DispatcherServlet;

@Order(value=-2147483648)
@Configuration
@Import(value={EmbeddedServletContainerCustomizerBeanPostProcessorRegistrar.class})
public class EmbeddedServletContainerAutoConfiguration {
    public static final String DEFAULT_DISPATCHER_SERVLET_BEAN_NAME = "dispatcherServlet";

    private static class DefaultServletCondition
    extends SpringBootCondition {
        private DefaultServletCondition() {
        }

        @Override
        public SpringBootCondition.Outcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            String[] beans = beanFactory.getBeanNamesForType(DispatcherServlet.class, false, false);
            if (beans.length == 0) {
                return SpringBootCondition.Outcome.match("no DispatcherServlet found");
            }
            if (Arrays.asList(beans).contains(EmbeddedServletContainerAutoConfiguration.DEFAULT_DISPATCHER_SERVLET_BEAN_NAME)) {
                return SpringBootCondition.Outcome.noMatch("found DispatcherServlet named dispatcherServlet");
            }
            return SpringBootCondition.Outcome.match("multiple DispatcherServlets found and none is named dispatcherServlet");
        }
    }

    public static class EmbeddedServletContainerCustomizerBeanPostProcessorRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private ConfigurableListableBeanFactory beanFactory;

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
            }
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.beanFactory != null && this.beanFactory.getBeansOfType(EmbeddedServletContainerCustomizerBeanPostProcessor.class).size() == 0) {
                RootBeanDefinition beanDefinition = new RootBeanDefinition(EmbeddedServletContainerCustomizerBeanPostProcessor.class);
                registry.registerBeanDefinition("embeddedServletContainerCustomizerBeanPostProcessor", (BeanDefinition)beanDefinition);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Server.class, Loader.class})
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedJetty {
        @Bean
        public JettyEmbeddedServletContainerFactory jettyEmbeddedServletContainerFactory() {
            return new JettyEmbeddedServletContainerFactory();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Tomcat.class})
    @ConditionalOnMissingBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public static class EmbeddedTomcat {
        @Bean
        public TomcatEmbeddedServletContainerFactory tomcatEmbeddedServletContainerFactory() {
            return new TomcatEmbeddedServletContainerFactory();
        }
    }

    @ConditionalOnClass(value={DispatcherServlet.class})
    public static class DispatcherServletConfiguration {
        @Bean(name={"dispatcherServlet"})
        @Conditional(value={DefaultServletCondition.class})
        public DispatcherServlet dispatcherServlet() {
            return new DispatcherServlet();
        }
    }
}

