/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.Condition;

public class AutoConfigurationReport {
    private static final String BEAN_NAME = "autoConfigurationReport";
    private final SortedMap<String, ConditionAndOutcomes> outcomes = new TreeMap<String, ConditionAndOutcomes>();

    private AutoConfigurationReport() {
    }

    public void recordConditionEvaluation(String source, Condition condition, ConditionOutcome outcome) {
        if (!this.outcomes.containsKey(source)) {
            this.outcomes.put(source, new ConditionAndOutcomes());
        }
        ((ConditionAndOutcomes)this.outcomes.get(source)).add(condition, outcome);
    }

    public Map<String, ConditionAndOutcomes> getConditionAndOutcomesBySource() {
        return Collections.unmodifiableMap(this.outcomes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoConfigurationReport get(ConfigurableListableBeanFactory beanFactory) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = beanFactory;
        synchronized (configurableListableBeanFactory) {
            try {
                return (AutoConfigurationReport)beanFactory.getBean(BEAN_NAME, AutoConfigurationReport.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                AutoConfigurationReport report = new AutoConfigurationReport();
                beanFactory.registerSingleton(BEAN_NAME, (Object)report);
                return report;
            }
        }
    }

    public static class ConditionAndOutcome {
        private final Condition condition;
        private final ConditionOutcome outcome;

        public ConditionAndOutcome(Condition condition, ConditionOutcome outcome) {
            this.condition = condition;
            this.outcome = outcome;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public ConditionOutcome getOutcome() {
            return this.outcome;
        }
    }

    public static class ConditionAndOutcomes
    implements Iterable<ConditionAndOutcome> {
        private List<ConditionAndOutcome> outcomes = new ArrayList<ConditionAndOutcome>();

        public void add(Condition condition, ConditionOutcome outcome) {
            this.outcomes.add(new ConditionAndOutcome(condition, outcome));
        }

        public boolean isFullMatch() {
            for (ConditionAndOutcome conditionAndOutcomes : this) {
                if (conditionAndOutcomes.getOutcome().isMatch()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<ConditionAndOutcome> iterator() {
            return Collections.unmodifiableList(this.outcomes).iterator();
        }
    }
}

