/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public abstract class AutoConfigurationUtils {
    private static final String BASE_PACKAGES_BEAN = AutoConfigurationUtils.class.getName() + ".basePackages";
    private static Set<String> EXCLUDED_PACKAGES;

    public static List<String> getBasePackages(BeanFactory beanFactory) {
        try {
            return (List)beanFactory.getBean(BASE_PACKAGES_BEAN, List.class);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return Collections.emptyList();
        }
    }

    public static void storeBasePackages(ConfigurableListableBeanFactory beanFactory, List<String> basePackages) {
        if (!beanFactory.containsBean(BASE_PACKAGES_BEAN)) {
            beanFactory.registerSingleton(BASE_PACKAGES_BEAN, new ArrayList());
        }
        List<String> storePackages = AutoConfigurationUtils.getBasePackages((BeanFactory)beanFactory);
        for (String basePackage : basePackages) {
            if (EXCLUDED_PACKAGES.contains(basePackage) || storePackages.contains(basePackage)) continue;
            storePackages.add(basePackage);
        }
    }

    static {
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("org.springframework.data.rest.webmvc");
        EXCLUDED_PACKAGES = Collections.unmodifiableSet(exclude);
    }
}

