/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationUtils;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ComponentScanDetector
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private BeanFactory beanFactory;
    private MetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.storeComponentScanBasePackages();
    }

    private void storeComponentScanBasePackages() {
        if (this.beanFactory instanceof ConfigurableListableBeanFactory) {
            this.storeComponentScanBasePackages((ConfigurableListableBeanFactory)this.beanFactory);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Unable to read @ComponentScan annotations for auto-configure");
        }
    }

    private void storeComponentScanBasePackages(ConfigurableListableBeanFactory beanFactory) {
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            String[] basePackagesAttribute = (String[])beanDefinition.getAttribute("componentScanBasePackages");
            if (basePackagesAttribute != null) {
                basePackages.addAll(Arrays.asList(basePackagesAttribute));
            }
            AnnotationMetadata metadata = this.getMetadata(beanDefinition);
            basePackages.addAll(this.getBasePackages(metadata));
        }
        AutoConfigurationUtils.storeBasePackages(beanFactory, basePackages);
    }

    private AnnotationMetadata getMetadata(BeanDefinition beanDefinition) {
        block5: {
            if (beanDefinition instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)beanDefinition).hasBeanClass()) {
                Class beanClass = ((AbstractBeanDefinition)beanDefinition).getBeanClass();
                if (Enhancer.isEnhanced((Class)beanClass)) {
                    beanClass = beanClass.getSuperclass();
                }
                return new StandardAnnotationMetadata(beanClass, true);
            }
            String className = beanDefinition.getBeanClassName();
            if (className != null) {
                try {
                    MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(className);
                    return metadataReader.getAnnotationMetadata();
                }
                catch (IOException ex) {
                    if (!this.logger.isDebugEnabled()) break block5;
                    this.logger.debug((Object)("Could not find class file for introspecting @ComponentScan classes: " + className), (Throwable)ex);
                }
            }
        }
        return null;
    }

    private List<String> getBasePackages(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(metadata == null ? null : metadata.getAnnotationAttributes(ComponentScan.class.getName(), true));
        if (attributes != null) {
            ArrayList<String> basePackages = new ArrayList<String>();
            this.addAllHavingText(basePackages, attributes.getStringArray("value"));
            this.addAllHavingText(basePackages, attributes.getStringArray("basePackages"));
            for (String packageClass : attributes.getStringArray("basePackageClasses")) {
                basePackages.add(ClassUtils.getPackageName((String)packageClass));
            }
            if (basePackages.isEmpty()) {
                basePackages.add(ClassUtils.getPackageName((String)metadata.getClassName()));
            }
            return basePackages;
        }
        return Collections.emptyList();
    }

    private void addAllHavingText(List<String> list, String[] strings) {
        for (String s : strings) {
            if (!StringUtils.hasText((String)s)) continue;
            list.add(s);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

