/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.batch.JobExecutionEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class JobLauncherCommandLineRunner
implements CommandLineRunner,
ApplicationEventPublisherAware {
    private static Log logger = LogFactory.getLog(JobLauncherCommandLineRunner.class);
    @Autowired(required=false)
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    @Autowired
    private JobLauncher jobLauncher;
    @Autowired(required=false)
    private Collection<Job> jobs = Collections.emptySet();
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void run(String ... args) throws JobExecutionException {
        logger.info((Object)("Running default command line with: " + Arrays.asList(args)));
        this.launchJobFromProperties(StringUtils.splitArrayElementsIntoProperties((String[])args, (String)"="));
    }

    protected void launchJobFromProperties(Properties properties) throws JobExecutionException {
        for (Job job : this.jobs) {
            JobExecution execution = this.jobLauncher.run(job, this.converter.getJobParameters(properties));
            if (this.publisher == null) continue;
            this.publisher.publishEvent((ApplicationEvent)new JobExecutionEvent(execution));
        }
    }
}

