/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;

@Configuration
@ConditionalOnClass(value={JmsTemplate.class, ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsTemplateProperties.class})
public class JmsTemplateAutoConfiguration {
    @Autowired
    private JmsTemplateProperties config;
    @Autowired
    private ConnectionFactory connectionFactory;

    @Bean
    @ConditionalOnMissingBean(value={JmsTemplate.class})
    public JmsTemplate jmsTemplate() {
        JmsTemplate jmsTemplate = new JmsTemplate(this.connectionFactory);
        jmsTemplate.setPubSubDomain(this.config.isPubSubDomain());
        return jmsTemplate;
    }

    @ConfigurationProperties(name="spring.activemq")
    public static class ActiveMQConnectionFactoryProperties {
        private String brokerURL = "tcp://localhost:61616";
        private boolean inMemory = true;
        private boolean pooled = false;

        public String getBrokerURL() {
            if (this.inMemory) {
                return "vm://localhost";
            }
            return this.brokerURL;
        }

        public void setBrokerURL(String brokerURL) {
            this.brokerURL = brokerURL;
        }

        public boolean isInMemory() {
            return this.inMemory;
        }

        public void setInMemory(boolean inMemory) {
            this.inMemory = inMemory;
        }

        public boolean isPooled() {
            return this.pooled;
        }

        public void setPooled(boolean pooled) {
            this.pooled = pooled;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ActiveMQConnectionFactory.class})
    @ConditionalOnMissingBean(value={ConnectionFactory.class})
    @EnableConfigurationProperties(value={ActiveMQConnectionFactoryProperties.class})
    protected static class ActiveMQConnectionFactoryCreator {
        @Autowired
        private ActiveMQConnectionFactoryProperties config;

        protected ActiveMQConnectionFactoryCreator() {
        }

        @Bean
        ConnectionFactory jmsConnectionFactory() {
            if (this.config.isPooled()) {
                PooledConnectionFactory pool = new PooledConnectionFactory();
                pool.setConnectionFactory((ConnectionFactory)new ActiveMQConnectionFactory(this.config.getBrokerURL()));
                return pool;
            }
            return new ActiveMQConnectionFactory(this.config.getBrokerURL());
        }
    }

    @ConfigurationProperties(name="spring.jms")
    public static class JmsTemplateProperties {
        private boolean pubSubDomain = true;

        public boolean isPubSubDomain() {
            return this.pubSubDomain;
        }

        public void setPubSubDomain(boolean pubSubDomain) {
            this.pubSubDomain = pubSubDomain;
        }
    }
}

