/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.Condition;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class AutoConfigurationReport {
    private static final String BEAN_NAME = "autoConfigurationReport";
    private final SortedMap<String, ConditionAndOutcomes> outcomes = new TreeMap<String, ConditionAndOutcomes>();
    private AutoConfigurationReport parent;

    private AutoConfigurationReport() {
    }

    public void recordConditionEvaluation(String source, Condition condition, ConditionOutcome outcome) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        Assert.notNull((Object)outcome, (String)"Outcome must not be null");
        if (!this.outcomes.containsKey(source)) {
            this.outcomes.put(source, new ConditionAndOutcomes());
        }
        ((ConditionAndOutcomes)this.outcomes.get(source)).add(condition, outcome);
    }

    public Map<String, ConditionAndOutcomes> getConditionAndOutcomesBySource() {
        return Collections.unmodifiableMap(this.outcomes);
    }

    public AutoConfigurationReport getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoConfigurationReport get(ConfigurableListableBeanFactory beanFactory) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = beanFactory;
        synchronized (configurableListableBeanFactory) {
            AutoConfigurationReport report;
            try {
                report = (AutoConfigurationReport)beanFactory.getBean(BEAN_NAME, AutoConfigurationReport.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                report = new AutoConfigurationReport();
                beanFactory.registerSingleton(BEAN_NAME, (Object)report);
            }
            AutoConfigurationReport.locateParent(beanFactory.getParentBeanFactory(), report);
            return report;
        }
    }

    private static void locateParent(BeanFactory beanFactory, AutoConfigurationReport report) {
        if (beanFactory != null && report.parent == null && beanFactory.containsBean(BEAN_NAME)) {
            report.parent = (AutoConfigurationReport)beanFactory.getBean(BEAN_NAME, AutoConfigurationReport.class);
        }
    }

    public static class ConditionAndOutcome {
        private final Condition condition;
        private final ConditionOutcome outcome;

        public ConditionAndOutcome(Condition condition, ConditionOutcome outcome) {
            this.condition = condition;
            this.outcome = outcome;
        }

        public Condition getCondition() {
            return this.condition;
        }

        public ConditionOutcome getOutcome() {
            return this.outcome;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ConditionAndOutcome other = (ConditionAndOutcome)obj;
            return ObjectUtils.nullSafeEquals(this.condition.getClass(), other.condition.getClass()) && ObjectUtils.nullSafeEquals((Object)this.outcome, (Object)other.outcome);
        }

        public int hashCode() {
            return this.condition.getClass().hashCode() * 31 + this.outcome.hashCode();
        }
    }

    public static class ConditionAndOutcomes
    implements Iterable<ConditionAndOutcome> {
        private final Set<ConditionAndOutcome> outcomes = new LinkedHashSet<ConditionAndOutcome>();

        public void add(Condition condition, ConditionOutcome outcome) {
            this.outcomes.add(new ConditionAndOutcome(condition, outcome));
        }

        public boolean isFullMatch() {
            for (ConditionAndOutcome conditionAndOutcomes : this) {
                if (conditionAndOutcomes.getOutcome().isMatch()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<ConditionAndOutcome> iterator() {
            return Collections.unmodifiableSet(this.outcomes).iterator();
        }
    }
}

