/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data;

import com.mongodb.Mongo;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
@ConditionalOnClass(value={Mongo.class, MongoTemplate.class})
public class MongoTemplateAutoConfiguration {
    @Autowired
    private MongoProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public MongoTemplate mongoTemplate(Mongo mongo) throws UnknownHostException {
        return new MongoTemplate(mongo, this.properties.getMongoClientDatabase());
    }
}

