/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.autoconfigure.orm.jpa.JpaBaseConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.orm.jpa.SpringNamingStrategy;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class, EnableTransactionManagement.class, EntityManager.class})
@Conditional(value={HibernateEntityManagerCondition.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class HibernateJpaAutoConfiguration
extends JpaBaseConfiguration
implements BeanClassLoaderAware {
    private RelaxedPropertyResolver environment = null;
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        this.environment = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.jpa.hibernate.");
    }

    @Override
    protected AbstractJpaVendorAdapter createJpaVendorAdapter() {
        return new HibernateJpaVendorAdapter();
    }

    @Override
    protected void configure(LocalContainerEntityManagerFactoryBean entityManagerFactoryBean) {
        Map properties = entityManagerFactoryBean.getJpaPropertyMap();
        properties.put("hibernate.ejb.naming_strategy", this.environment.getProperty("naming-strategy", SpringNamingStrategy.class.getName()));
        String ddlAuto = this.environment.getProperty("ddl-auto", this.getDefaultDdlAuto());
        if (!"none".equals(ddlAuto)) {
            properties.put("hibernate.hbm2ddl.auto", ddlAuto);
        }
    }

    private String getDefaultDdlAuto() {
        EmbeddedDatabaseConnection embeddedDatabaseConnection = EmbeddedDatabaseConnection.get(this.classLoader);
        if (embeddedDatabaseConnection == EmbeddedDatabaseConnection.NONE) {
            return "none";
        }
        return "create-drop";
    }

    static class HibernateEntityManagerCondition
    extends SpringBootCondition {
        private static String[] CLASS_NAMES = new String[]{"org.hibernate.ejb.HibernateEntityManager", "org.hibernate.jpa.HibernateEntityManager"};

        HibernateEntityManagerCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            for (String className : CLASS_NAMES) {
                if (!ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader())) continue;
                return ConditionOutcome.match("found HibernateEntityManager class");
            }
            return ConditionOutcome.noMatch("did not find HibernateEntityManager class");
        }
    }
}

