/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jdbc.DriverClassNameProvider;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.datasource")
public class DataSourceProperties
implements BeanClassLoaderAware,
InitializingBean {
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private ClassLoader classLoader;
    private boolean initialize = true;
    private String platform = "all";
    private String schema;
    private String data;
    private boolean continueOnError = false;
    private String separator = ";";
    private EmbeddedDatabaseConnection embeddedDatabaseConnection = EmbeddedDatabaseConnection.NONE;
    private DriverClassNameProvider driverClassNameProvider = new DriverClassNameProvider();

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.embeddedDatabaseConnection = EmbeddedDatabaseConnection.get(this.classLoader);
    }

    protected String getDriverClassName() {
        if (StringUtils.hasText((String)this.driverClassName)) {
            Assert.state((boolean)ClassUtils.isPresent((String)this.driverClassName, null), (String)("Cannot load driver class: " + this.driverClassName));
            return this.driverClassName;
        }
        String driverClassName = null;
        if (StringUtils.hasText((String)this.url)) {
            driverClassName = this.driverClassNameProvider.getDriverClassName(this.url);
        }
        if (!StringUtils.hasText(driverClassName)) {
            driverClassName = this.embeddedDatabaseConnection.getDriverClassName();
        }
        if (!StringUtils.hasText(driverClassName)) {
            throw new BeanCreationException("Cannot determine embedded database driver class for database type " + (Object)((Object)this.embeddedDatabaseConnection) + ". If you want an embedded " + "database please put a supported one on the classpath.");
        }
        return driverClassName;
    }

    public String getUrl() {
        if (StringUtils.hasText((String)this.url)) {
            return this.url;
        }
        String url = this.embeddedDatabaseConnection.getUrl();
        if (!StringUtils.hasText((String)url)) {
            throw new BeanCreationException("Cannot determine embedded database url for database type " + (Object)((Object)this.embeddedDatabaseConnection) + ". If you want an embedded " + "database please put a supported on on the classpath.");
        }
        return url;
    }

    public String getUsername() {
        if (StringUtils.hasText((String)this.username)) {
            return this.username;
        }
        if (EmbeddedDatabaseConnection.isEmbedded(this.driverClassName)) {
            return "sa";
        }
        return null;
    }

    public String getPassword() {
        if (StringUtils.hasText((String)this.password)) {
            return this.password;
        }
        if (EmbeddedDatabaseConnection.isEmbedded(this.driverClassName)) {
            return "";
        }
        return null;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String script) {
        this.data = script;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

