/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jmx;

import javax.management.MBeanServer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.jmx.ParentAwareNamingStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableMBeanExport;
import org.springframework.context.annotation.MBeanExportConfiguration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.MBeanServerFactoryBean;

@Configuration
@ConditionalOnClass(value={MBeanExporter.class})
@ConditionalOnExpression(value="${spring.jmx.enabled:true}")
public class JmxAutoConfiguration {
    @Autowired
    private Environment environment;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private ObjectNamingStrategy namingStrategy;

    @Bean
    @ConditionalOnMissingBean(value={MBeanExporter.class}, search=SearchStrategy.CURRENT)
    public AnnotationMBeanExporter mbeanExporter() {
        MBeanExportConfiguration config = new MBeanExportConfiguration();
        config.setEnvironment(this.environment);
        config.setBeanFactory(this.beanFactory);
        config.setImportMetadata((AnnotationMetadata)new StandardAnnotationMetadata(Empty.class));
        AnnotationMBeanExporter exporter = config.mbeanExporter();
        exporter.setNamingStrategy(this.namingStrategy);
        return exporter;
    }

    @Bean
    @ConditionalOnMissingBean(value={ObjectNamingStrategy.class})
    public ParentAwareNamingStrategy objectNamingStrategy() {
        return new ParentAwareNamingStrategy((JmxAttributeSource)new AnnotationJmxAttributeSource());
    }

    @Bean
    @ConditionalOnMissingBean(value={MBeanServer.class})
    public MBeanServerFactoryBean mbeanServer() {
        MBeanServerFactoryBean factory = new MBeanServerFactoryBean();
        factory.setLocateExistingServerIfPossible(true);
        return factory;
    }

    @EnableMBeanExport(defaultDomain="${spring.jmx.default_domain:}", server="${spring.jmx.server:mbeanServer}")
    private static class Empty {
        private Empty() {
        }
    }
}

