/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.social.config.annotation.ConnectionFactoryConfigurer;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.ConnectionFactory;

@ConditionalOnClass(value={SocialConfigurerAdapter.class})
abstract class SocialAutoConfigurerAdapter
extends SocialConfigurerAdapter
implements EnvironmentAware {
    private RelaxedPropertyResolver properties;

    SocialAutoConfigurerAdapter() {
    }

    public void setEnvironment(Environment environment) {
        this.properties = new RelaxedPropertyResolver((PropertyResolver)environment, this.getPropertyPrefix());
    }

    protected abstract String getPropertyPrefix();

    public void addConnectionFactories(ConnectionFactoryConfigurer configurer, Environment environment) {
        configurer.addConnectionFactory(this.createConnectionFactory(this.properties));
    }

    protected final RelaxedPropertyResolver getProperties() {
        return this.properties;
    }

    protected abstract ConnectionFactory<?> createConnectionFactory(RelaxedPropertyResolver var1);
}

