/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnJavaCondition
extends SpringBootCondition {
    private static final ConditionalOnJava.JavaVersion JVM_VERSION = ConditionalOnJava.JavaVersion.getJavaVersion();

    OnJavaCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnJava.class.getName());
        ConditionalOnJava.Range range = (ConditionalOnJava.Range)((Object)attributes.get("range"));
        ConditionalOnJava.JavaVersion version = (ConditionalOnJava.JavaVersion)((Object)attributes.get("value"));
        return this.getMatchOutcome(range, JVM_VERSION, version);
    }

    protected ConditionOutcome getMatchOutcome(ConditionalOnJava.Range range, ConditionalOnJava.JavaVersion runningVersion, ConditionalOnJava.JavaVersion version) {
        boolean match = runningVersion.isWithin(range, version);
        return new ConditionOutcome(match, this.getMessage(range, runningVersion, version));
    }

    private String getMessage(ConditionalOnJava.Range range, ConditionalOnJava.JavaVersion runningVersion, ConditionalOnJava.JavaVersion version) {
        String expected = String.format(range == ConditionalOnJava.Range.EQUAL_OR_NEWER ? "%s or newer" : "older than %s", new Object[]{version});
        return "Required JVM version " + expected + " found " + (Object)((Object)runningVersion);
    }
}

