/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.HttpMapperProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
public class JacksonAutoConfiguration {
    @Autowired
    private ListableBeanFactory beanFactory;

    @PostConstruct
    private void registerModulesWithObjectMappers() {
        Collection<Module> modules = this.getBeans(Module.class);
        for (ObjectMapper objectMapper : this.getBeans(ObjectMapper.class)) {
            objectMapper.registerModules(modules);
        }
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, type).values();
    }

    @Configuration
    @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.EIGHT)
    @ConditionalOnClass(value={JSR310Module.class})
    static class Jsr310ModuleAutoConfiguration {
        Jsr310ModuleAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JSR310Module jacksonJsr310Module() {
            return new JSR310Module();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JodaModule.class})
    static class JodaModuleAutoConfiguration {
        JodaModuleAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JodaModule jacksonJodaModule() {
            return new JodaModule();
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class})
    static class JacksonObjectMapperAutoConfiguration {
        @Autowired
        private HttpMapperProperties properties = new HttpMapperProperties();

        JacksonObjectMapperAutoConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean
        public ObjectMapper jacksonObjectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            if (this.properties.isJsonSortKeys()) {
                objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            }
            return objectMapper;
        }
    }
}

