/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jersey;

import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.ws.rs.ApplicationPath;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spring.SpringComponentProvider;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.DispatcherServletAutoConfiguration;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.filter.RequestContextFilter;

@Configuration
@ConditionalOnClass(value={SpringComponentProvider.class, ServletRegistration.class})
@ConditionalOnBean(value={ResourceConfig.class})
@ConditionalOnWebApplication
@Order(value=-2147483648)
@AutoConfigureBefore(value={DispatcherServletAutoConfiguration.class})
public class JerseyAutoConfiguration
implements WebApplicationInitializer {
    @Autowired
    private ListableBeanFactory context;
    @Autowired
    private ResourceConfig config;
    private String path;

    @PostConstruct
    public void path() {
        this.path = JerseyAutoConfiguration.findPath((ApplicationPath)AnnotationUtils.findAnnotation(this.config.getClass(), ApplicationPath.class));
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestContextFilter requestContextFilter() {
        return new RequestContextFilter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"jerseyServletRegistration"})
    public ServletRegistrationBean jerseyServletRegistration() {
        Class<?> configType = this.config.getClass();
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new ServletContainer(), new String[]{this.path});
        registration.addInitParameter("javax.ws.rs.Application", configType.getName());
        registration.setName("jerseyServlet");
        return registration;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        servletContext.setInitParameter("contextConfigLocation", "<NONE>");
    }

    private static String findPath(ApplicationPath annotation) {
        if (annotation == null) {
            return "/*";
        }
        String path = annotation.value();
        return path.isEmpty() || path.equals("/") ? "/*" : path + "/*";
    }
}

