/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

abstract class BeanTypeRegistry {
    static Log logger = LogFactory.getLog(BeanTypeRegistry.class);
    static final String FACTORY_BEAN_OBJECT_TYPE = "factoryBeanObjectType";

    BeanTypeRegistry() {
    }

    public abstract Set<String> getNamesForType(Class<?> var1);

    protected final Class<?> getFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, String name) {
        try {
            return this.doGetFactoryBeanGeneric(beanFactory, definition, name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Class<?> doGetFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, String name) throws Exception, ClassNotFoundException, LinkageError {
        if (StringUtils.hasLength((String)definition.getFactoryBeanName()) && StringUtils.hasLength((String)definition.getFactoryMethodName())) {
            return this.getConfigurationClassFactoryBeanGeneric(beanFactory, definition, name);
        }
        if (StringUtils.hasLength((String)definition.getBeanClassName())) {
            return this.getDirectFactoryBeanGeneric(beanFactory, definition, name);
        }
        return null;
    }

    private Class<?> getConfigurationClassFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, String name) throws Exception {
        BeanDefinition factoryDefinition = beanFactory.getBeanDefinition(definition.getFactoryBeanName());
        Class factoryClass = ClassUtils.forName((String)factoryDefinition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        Method method = ReflectionUtils.findMethod((Class)factoryClass, (String)definition.getFactoryMethodName());
        Class generic = ResolvableType.forMethodReturnType((Method)method).as(FactoryBean.class).resolveGeneric(new int[0]);
        if ((generic == null || generic.equals(Object.class)) && definition.hasAttribute(FACTORY_BEAN_OBJECT_TYPE)) {
            generic = (Class)definition.getAttribute(FACTORY_BEAN_OBJECT_TYPE);
        }
        return generic;
    }

    private Class<?> getDirectFactoryBeanGeneric(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition, String name) throws ClassNotFoundException, LinkageError {
        Class factoryBeanClass = ClassUtils.forName((String)definition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        Class generic = ResolvableType.forClass((Class)factoryBeanClass).as(FactoryBean.class).resolveGeneric(new int[0]);
        if ((generic == null || generic.equals(Object.class)) && definition.hasAttribute(FACTORY_BEAN_OBJECT_TYPE)) {
            generic = (Class)definition.getAttribute(FACTORY_BEAN_OBJECT_TYPE);
        }
        return generic;
    }

    public static BeanTypeRegistry get(ListableBeanFactory beanFactory) {
        DefaultListableBeanFactory listableBeanFactory;
        if (beanFactory instanceof DefaultListableBeanFactory && (listableBeanFactory = (DefaultListableBeanFactory)beanFactory).isAllowEagerClassLoading()) {
            return OptimizedBeanTypeRegistry.getFromFactory(listableBeanFactory);
        }
        return new DefaultBeanTypeRegistry(beanFactory);
    }

    static class OptimizedBeanTypeRegistry
    extends BeanTypeRegistry
    implements SmartInitializingSingleton {
        private static final String BEAN_NAME = BeanTypeRegistry.class.getName();
        private final DefaultListableBeanFactory beanFactory;
        private final Map<String, Class<?>> beanTypes = new HashMap();
        private int lastBeanDefinitionCount = 0;

        public OptimizedBeanTypeRegistry(DefaultListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public void afterSingletonsInstantiated() {
            this.beanTypes.clear();
            this.lastBeanDefinitionCount = 0;
        }

        @Override
        public Set<String> getNamesForType(Class<?> type) {
            if (this.lastBeanDefinitionCount != this.beanFactory.getBeanDefinitionCount()) {
                Iterator names = this.beanFactory.getBeanNamesIterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (this.beanTypes.containsKey(name)) continue;
                    this.addBeanType(name);
                }
                this.lastBeanDefinitionCount = this.beanFactory.getBeanDefinitionCount();
            }
            LinkedHashSet<String> matches = new LinkedHashSet<String>();
            for (Map.Entry<String, Class<?>> entry : this.beanTypes.entrySet()) {
                if (entry.getValue() == null || !type.isAssignableFrom(entry.getValue())) continue;
                matches.add(entry.getKey());
            }
            return matches;
        }

        private void addBeanType(String name) {
            if (this.beanFactory.containsSingleton(name)) {
                this.beanTypes.put(name, this.beanFactory.getType(name));
            } else if (!this.beanFactory.isAlias(name)) {
                this.addBeanTypeForNonAliasDefinition(name);
            }
        }

        private void addBeanTypeForNonAliasDefinition(String name) {
            try {
                String factoryName = "&" + name;
                RootBeanDefinition beanDefinition = (RootBeanDefinition)this.beanFactory.getMergedBeanDefinition(name);
                if (!beanDefinition.isAbstract() && !this.requiresEagerInit(beanDefinition.getFactoryBeanName())) {
                    if (this.beanFactory.isFactoryBean(factoryName)) {
                        Class<?> factoryBeanGeneric = this.getFactoryBeanGeneric((ConfigurableListableBeanFactory)this.beanFactory, (BeanDefinition)beanDefinition, name);
                        this.beanTypes.put(name, factoryBeanGeneric);
                        this.beanTypes.put(factoryName, this.beanFactory.getType(factoryName));
                    } else {
                        this.beanTypes.put(name, this.beanFactory.getType(name));
                    }
                }
            }
            catch (CannotLoadBeanClassException ex) {
                this.logIgnoredError("bean class loading failure for bean", name, (Exception)((Object)ex));
            }
            catch (BeanDefinitionStoreException ex) {
                this.logIgnoredError("unresolvable metadata in bean definition", name, (Exception)((Object)ex));
            }
        }

        private void logIgnoredError(String message, String name, Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring " + message + " '" + name + "'"), (Throwable)ex);
            }
        }

        private boolean requiresEagerInit(String factoryBeanName) {
            return factoryBeanName != null && this.beanFactory.isFactoryBean(factoryBeanName) && !this.beanFactory.containsSingleton(factoryBeanName);
        }

        public static OptimizedBeanTypeRegistry getFromFactory(DefaultListableBeanFactory factory) {
            if (!factory.containsLocalBean(BEAN_NAME)) {
                RootBeanDefinition bd = new RootBeanDefinition(OptimizedBeanTypeRegistry.class);
                bd.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)factory);
                factory.registerBeanDefinition(BEAN_NAME, (BeanDefinition)bd);
            }
            return (OptimizedBeanTypeRegistry)factory.getBean(BEAN_NAME, OptimizedBeanTypeRegistry.class);
        }
    }

    static class DefaultBeanTypeRegistry
    extends BeanTypeRegistry {
        private final ListableBeanFactory beanFactory;

        public DefaultBeanTypeRegistry(ListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        @Override
        public Set<String> getNamesForType(Class<?> type) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            result.addAll(Arrays.asList(this.beanFactory.getBeanNamesForType(type, true, false)));
            if (this.beanFactory instanceof ConfigurableListableBeanFactory) {
                this.collectBeanNamesForTypeFromFactoryBeans(result, (ConfigurableListableBeanFactory)this.beanFactory, type);
            }
            return result;
        }

        private void collectBeanNamesForTypeFromFactoryBeans(Set<String> result, ConfigurableListableBeanFactory beanFactory, Class<?> type) {
            String[] names;
            for (String name : names = beanFactory.getBeanNamesForType(FactoryBean.class, true, false)) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name = BeanFactoryUtils.transformedBeanName((String)name));
                Class<?> generic = this.getFactoryBeanGeneric(beanFactory, beanDefinition, name);
                if (generic == null || !ClassUtils.isAssignable(type, generic)) continue;
                result.add(name);
            }
        }
    }
}

