/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo.embedded;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.ArtifactStoreBuilder;
import de.flapdoodle.embed.mongo.config.DownloadConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.io.progress.Slf4jProgressListener;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.embedded.EmbeddedMongoProperties;
import org.springframework.boot.autoconfigure.mongo.embedded.MongoClientDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

@Configuration
@EnableConfigurationProperties(value={MongoProperties.class, EmbeddedMongoProperties.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class})
@ConditionalOnClass(value={Mongo.class, MongodStarter.class})
public class EmbeddedMongoAutoConfiguration {
    @Autowired
    private MongoProperties properties;
    @Autowired
    private EmbeddedMongoProperties embeddedProperties;
    @Autowired
    private ApplicationContext context;

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    public MongodExecutable embeddedMongoServer(IMongodConfig mongodConfig, IRuntimeConfig runtimeConfig) throws IOException {
        return this.createEmbeddedMongoServer(mongodConfig, runtimeConfig);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    public MongodExecutable embeddedMongoServer(IMongodConfig mongodConfig) throws IOException {
        return this.createEmbeddedMongoServer(mongodConfig, null);
    }

    private MongodExecutable createEmbeddedMongoServer(IMongodConfig mongodConfig, IRuntimeConfig runtimeConfig) {
        if (this.getPort() == 0) {
            this.publishPortInfo(mongodConfig.net().getPort());
        }
        MongodStarter mongodStarter = runtimeConfig == null ? MongodStarter.getDefaultInstance() : MongodStarter.getInstance((IRuntimeConfig)runtimeConfig);
        return (MongodExecutable)mongodStarter.prepare((IExecutableProcessConfig)mongodConfig);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Logger.class})
    public IRuntimeConfig embeddedMongoRuntimeConfig() {
        Logger logger = LoggerFactory.getLogger((String)(this.getClass().getPackage().getName() + ".EmbeddedMongo"));
        ProcessOutput processOutput = new ProcessOutput(Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.INFO), Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.ERROR), Processors.named((String)"[console>]", (IStreamProcessor)Processors.logTo((Logger)logger, (Slf4jLevel)Slf4jLevel.DEBUG)));
        return new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, logger).processOutput(processOutput).artifactStore((AbstractBuilder)new ArtifactStoreBuilder().defaults(Command.MongoD).download((AbstractBuilder)new DownloadConfigBuilder().defaultsForCommand(Command.MongoD).progressListener((IProgressListener)new Slf4jProgressListener(logger)))).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public IMongodConfig embeddedMongoConfiguration() throws IOException {
        ToStringFriendlyFeatureAwareVersion featureAwareVersion = new ToStringFriendlyFeatureAwareVersion(this.embeddedProperties.getVersion(), this.embeddedProperties.getFeatures());
        MongodConfigBuilder builder = new MongodConfigBuilder().version((IFeatureAwareVersion)featureAwareVersion);
        if (this.getPort() > 0) {
            builder.net(new Net(this.getPort(), Network.localhostIsIPv6()));
        }
        return builder.build();
    }

    private int getPort() {
        return this.properties.getPort() == null ? 27017 : this.properties.getPort();
    }

    private void publishPortInfo(int port) {
        this.setPortProperty(this.context, port);
    }

    private void setPortProperty(ApplicationContext context, int port) {
        if (context instanceof ConfigurableApplicationContext) {
            Map<String, Integer> map;
            ConfigurableEnvironment environment = ((ConfigurableApplicationContext)context).getEnvironment();
            MutablePropertySources sources = environment.getPropertySources();
            if (!sources.contains("mongo.ports")) {
                map = new HashMap();
                MapPropertySource source = new MapPropertySource("mongo.ports", map);
                sources.addFirst((PropertySource)source);
            } else {
                Map value = (Map)sources.get("mongo.ports").getSource();
                map = value;
            }
            map.put("local.mongo.port", port);
        }
        if (this.context.getParent() != null) {
            this.setPortProperty(this.context.getParent(), port);
        }
    }

    private static class ToStringFriendlyFeatureAwareVersion
    implements IFeatureAwareVersion {
        private final String version;
        private final Set<Feature> features;

        private ToStringFriendlyFeatureAwareVersion(String version, Set<Feature> features) {
            Assert.notNull((Object)version, (String)"version must not be null");
            this.version = version;
            this.features = features == null ? Collections.emptySet() : features;
        }

        public String asInDownloadPath() {
            return this.version;
        }

        public boolean enabled(Feature feature) {
            return this.features.contains(feature);
        }

        public String toString() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.features.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ToStringFriendlyFeatureAwareVersion other = (ToStringFriendlyFeatureAwareVersion)obj;
            if (!this.features.equals(other.features)) {
                return false;
            }
            return this.version.equals(other.version);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MongoClient.class})
    protected static class EmbeddedMongoDependencyConfiguration
    extends MongoClientDependsOnBeanFactoryPostProcessor {
        public EmbeddedMongoDependencyConfiguration() {
            super("embeddedMongoServer");
        }
    }
}

