/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.cache.HazelcastCacheManager;
import java.io.Closeable;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheCondition;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastConfigResourceCondition;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastInstanceFactory;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
@ConditionalOnClass(value={HazelcastInstance.class, HazelcastCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@Conditional(value={CacheCondition.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
class HazelcastCacheConfiguration {
    HazelcastCacheConfiguration() {
    }

    private static class CloseableHazelcastCacheManager
    extends HazelcastCacheManager
    implements Closeable {
        private final HazelcastInstance hazelcastInstance;

        public CloseableHazelcastCacheManager(HazelcastInstance hazelcastInstance) {
            super(hazelcastInstance);
            this.hazelcastInstance = hazelcastInstance;
        }

        @Override
        public void close() throws IOException {
            this.hazelcastInstance.shutdown();
        }
    }

    static class ConfigAvailableCondition
    extends HazelcastConfigResourceCondition {
        public ConfigAvailableCondition() {
            super("spring.cache.hazelcast", "config");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={HazelcastInstance.class})
    @Conditional(value={ConfigAvailableCondition.class})
    static class DefaultHazelcastInstanceConfiguration {
        @Autowired
        private CacheProperties cacheProperties;

        DefaultHazelcastInstanceConfiguration() {
        }

        @Bean
        public HazelcastInstance hazelcastInstance() throws IOException {
            Resource config = this.cacheProperties.getHazelcast().getConfig();
            Resource location = this.cacheProperties.resolveConfigLocation(config);
            if (location != null) {
                new HazelcastInstanceFactory(location).getHazelcastInstance();
            }
            return Hazelcast.newHazelcastInstance();
        }

        @Bean
        public HazelcastCacheManager cacheManager() throws IOException {
            return new HazelcastCacheManager(this.hazelcastInstance());
        }
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=HazelcastInstance.class)
    static class ExistingHazelcastInstanceConfiguration {
        @Autowired
        private CacheProperties cacheProperties;

        ExistingHazelcastInstanceConfiguration() {
        }

        @Bean
        public HazelcastCacheManager cacheManager(HazelcastInstance existingHazelcastInstance) throws IOException {
            Resource config = this.cacheProperties.getHazelcast().getConfig();
            Resource location = this.cacheProperties.resolveConfigLocation(config);
            if (location != null) {
                HazelcastInstance cacheHazelcastInstance = new HazelcastInstanceFactory(location).getHazelcastInstance();
                return new CloseableHazelcastCacheManager(cacheHazelcastInstance);
            }
            return new HazelcastCacheManager(existingHazelcastInstance);
        }
    }
}

