/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2Sso;
import org.springframework.boot.autoconfigure.security.oauth2.client.SsoSecurityConfigurer;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@Conditional(value={WebSecurityEnhancerCondition.class})
public class OAuth2SsoCustomConfiguration
implements ImportAware,
BeanPostProcessor,
BeanFactoryAware {
    private Class<?> configType;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.configType = ClassUtils.resolveClassName((String)importMetadata.getClassName(), null);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.configType.isAssignableFrom(bean.getClass()) && bean instanceof WebSecurityConfigurerAdapter) {
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget(bean);
            factory.addAdvice((Advice)new SsoSecurityAdapter(this.beanFactory));
            bean = factory.getProxy();
        }
        return bean;
    }

    protected static class WebSecurityEnhancerCondition
    extends SpringBootCondition {
        protected WebSecurityEnhancerCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String[] enablers;
            for (String name : enablers = context.getBeanFactory().getBeanNamesForAnnotation(EnableOAuth2Sso.class)) {
                if (!context.getBeanFactory().isTypeMatch(name, WebSecurityConfigurerAdapter.class)) continue;
                return ConditionOutcome.match("found @EnableOAuth2Sso on a WebSecurityConfigurerAdapter");
            }
            return ConditionOutcome.noMatch("found no @EnableOAuth2Sso on a WebSecurityConfigurerAdapter");
        }
    }

    private static class SsoSecurityAdapter
    implements MethodInterceptor {
        private SsoSecurityConfigurer configurer;

        public SsoSecurityAdapter(BeanFactory beanFactory) {
            this.configurer = new SsoSecurityConfigurer(beanFactory);
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().getName().equals("init")) {
                Method method = ReflectionUtils.findMethod(WebSecurityConfigurerAdapter.class, (String)"getHttp");
                ReflectionUtils.makeAccessible((Method)method);
                HttpSecurity http = (HttpSecurity)ReflectionUtils.invokeMethod((Method)method, (Object)invocation.getThis());
                this.configurer.configure(http);
            }
            return invocation.proceed();
        }
    }
}

