/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.method;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.expression.OAuth2MethodSecurityExpressionHandler;

@Configuration
@ConditionalOnClass(value={OAuth2AccessToken.class})
@ConditionalOnBean(value={GlobalMethodSecurityConfiguration.class})
public class OAuth2MethodSecurityConfiguration
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        OAuth2ExpressionHandlerInjectionPostProcessor processor = new OAuth2ExpressionHandlerInjectionPostProcessor(this.applicationContext);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)processor);
    }

    private static class OAuth2ExpressionHandlerInjectionPostProcessor
    implements BeanPostProcessor {
        private ApplicationContext applicationContext;

        public OAuth2ExpressionHandlerInjectionPostProcessor(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof DefaultMethodSecurityExpressionHandler && !(bean instanceof OAuth2MethodSecurityExpressionHandler)) {
                return this.getExpressionHandler((DefaultMethodSecurityExpressionHandler)bean);
            }
            return bean;
        }

        private OAuth2MethodSecurityExpressionHandler getExpressionHandler(DefaultMethodSecurityExpressionHandler bean) {
            PermissionEvaluator permissions;
            OAuth2MethodSecurityExpressionHandler handler = new OAuth2MethodSecurityExpressionHandler();
            handler.setApplicationContext(this.applicationContext);
            AuthenticationTrustResolver trustResolver = this.findInContext(AuthenticationTrustResolver.class);
            if (trustResolver != null) {
                handler.setTrustResolver(trustResolver);
            }
            if ((permissions = this.findInContext(PermissionEvaluator.class)) != null) {
                handler.setPermissionEvaluator(permissions);
            }
            handler.setExpressionParser(bean.getExpressionParser());
            return handler;
        }

        private <T> T findInContext(Class<T> type) {
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, type).length == 1) {
                return (T)this.applicationContext.getBean(type);
            }
            return null;
        }
    }
}

