/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AutoConfigurationReportLoggingInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableApplicationContext applicationContext;
    private ConditionEvaluationReport report;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        applicationContext.addApplicationListener((ApplicationListener)new AutoConfigurationReportListener());
        if (applicationContext instanceof GenericApplicationContext) {
            this.report = ConditionEvaluationReport.get(this.applicationContext.getBeanFactory());
        }
    }

    protected void onApplicationEvent(ApplicationEvent event) {
        ConfigurableApplicationContext initializerApplicationContext = this.applicationContext;
        if (event instanceof ContextRefreshedEvent) {
            if (((ApplicationContextEvent)event).getApplicationContext() == initializerApplicationContext) {
                this.logAutoConfigurationReport();
            }
        } else if (event instanceof ApplicationFailedEvent && ((ApplicationFailedEvent)event).getApplicationContext() == initializerApplicationContext) {
            this.logAutoConfigurationReport(true);
        }
    }

    private void logAutoConfigurationReport() {
        this.logAutoConfigurationReport(!this.applicationContext.isActive());
    }

    public void logAutoConfigurationReport(boolean isCrashReport) {
        if (this.report == null) {
            if (this.applicationContext == null) {
                this.logger.info((Object)"Unable to provide auto-configuration report due to missing ApplicationContext");
                return;
            }
            this.report = ConditionEvaluationReport.get(this.applicationContext.getBeanFactory());
        }
        if (!this.report.getConditionAndOutcomesBySource().isEmpty()) {
            if (isCrashReport && this.logger.isInfoEnabled() && !this.logger.isDebugEnabled()) {
                this.logger.info((Object)String.format("%n%nError starting ApplicationContext. To display the auto-configuration report enable debug logging (start with --debug)%n%n", new Object[0]));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.getLogMessage(this.report));
            }
        }
    }

    private StringBuilder getLogMessage(ConditionEvaluationReport report) {
        StringBuilder message = new StringBuilder();
        message.append(String.format("%n%n%n", new Object[0]));
        message.append(String.format("=========================%n", new Object[0]));
        message.append(String.format("AUTO-CONFIGURATION REPORT%n", new Object[0]));
        message.append(String.format("=========================%n%n%n", new Object[0]));
        message.append(String.format("Positive matches:%n", new Object[0]));
        message.append(String.format("-----------------%n", new Object[0]));
        Map<String, ConditionEvaluationReport.ConditionAndOutcomes> shortOutcomes = this.orderByName(report.getConditionAndOutcomesBySource());
        for (Map.Entry<String, ConditionEvaluationReport.ConditionAndOutcomes> entry : shortOutcomes.entrySet()) {
            if (!entry.getValue().isFullMatch()) continue;
            this.addLogMessage(message, entry.getKey(), entry.getValue());
        }
        message.append(String.format("%n%n", new Object[0]));
        message.append(String.format("Negative matches:%n", new Object[0]));
        message.append(String.format("-----------------%n", new Object[0]));
        for (Map.Entry<String, ConditionEvaluationReport.ConditionAndOutcomes> entry : shortOutcomes.entrySet()) {
            if (entry.getValue().isFullMatch()) continue;
            this.addLogMessage(message, entry.getKey(), entry.getValue());
        }
        message.append(String.format("%n%n", new Object[0]));
        message.append(String.format("Exclusions:%n", new Object[0]));
        message.append(String.format("-----------%n", new Object[0]));
        if (report.getExclusions().isEmpty()) {
            message.append(String.format("%n    None%n", new Object[0]));
        } else {
            for (String exclusion : report.getExclusions()) {
                message.append(String.format("%n    %s%n", exclusion));
            }
        }
        message.append(String.format("%n%n", new Object[0]));
        message.append(String.format("Unconditional classes:%n", new Object[0]));
        message.append(String.format("----------------------%n", new Object[0]));
        if (report.getUnconditionalClasses().isEmpty()) {
            message.append(String.format("%n    None%n", new Object[0]));
        } else {
            for (String unconditionalClass : report.getUnconditionalClasses()) {
                message.append(String.format("%n    %s%n", unconditionalClass));
            }
        }
        message.append(String.format("%n%n", new Object[0]));
        return message;
    }

    private Map<String, ConditionEvaluationReport.ConditionAndOutcomes> orderByName(Map<String, ConditionEvaluationReport.ConditionAndOutcomes> outcomes) {
        LinkedHashMap<String, ConditionEvaluationReport.ConditionAndOutcomes> result = new LinkedHashMap<String, ConditionEvaluationReport.ConditionAndOutcomes>();
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, String> classNames = new HashMap<String, String>();
        for (String name : outcomes.keySet()) {
            String shortName = ClassUtils.getShortName((String)name);
            names.add(shortName);
            classNames.put(shortName, name);
        }
        Collections.sort(names);
        for (String shortName : names) {
            result.put(shortName, outcomes.get(classNames.get(shortName)));
        }
        return result;
    }

    private void addLogMessage(StringBuilder message, String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
        message.append(String.format("%n   %s", source));
        message.append(conditionAndOutcomes.isFullMatch() ? " matched" : " did not match").append(String.format("%n", new Object[0]));
        for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
            message.append("      - ");
            if (StringUtils.hasLength((String)conditionAndOutcome.getOutcome().getMessage())) {
                message.append(conditionAndOutcome.getOutcome().getMessage());
            } else {
                message.append(conditionAndOutcome.getOutcome().isMatch() ? "matched" : "did not match");
            }
            message.append(" (");
            message.append(ClassUtils.getShortName(conditionAndOutcome.getCondition().getClass()));
            message.append(String.format(")%n", new Object[0]));
        }
    }

    private class AutoConfigurationReportListener
    implements GenericApplicationListener {
        private AutoConfigurationReportListener() {
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public boolean supportsEventType(ResolvableType resolvableType) {
            Class type = resolvableType.getRawClass();
            if (type == null) {
                return false;
            }
            return ContextRefreshedEvent.class.isAssignableFrom(type) || ApplicationFailedEvent.class.isAssignableFrom(type);
        }

        public boolean supportsSourceType(Class<?> sourceType) {
            return true;
        }

        public void onApplicationEvent(ApplicationEvent event) {
            AutoConfigurationReportLoggingInitializer.this.onApplicationEvent(event);
        }
    }
}

