/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.autoconfigure.EnableAutoConfigurationImportSelector;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

class ImportAutoConfigurationImportSelector
extends EnableAutoConfigurationImportSelector {
    private static final Set<String> ANNOTATION_NAMES;

    ImportAutoConfigurationImportSelector() {
    }

    @Override
    protected AnnotationAttributes getAttributes(AnnotationMetadata metadata) {
        return null;
    }

    @Override
    protected List<String> getCandidateConfigurations(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        try {
            return this.getCandidateConfigurations(ClassUtils.forName((String)metadata.getClassName(), null));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private List<String> getCandidateConfigurations(Class<?> source) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        this.collectCandidateConfigurations(source, candidates);
        return new ArrayList<String>(candidates);
    }

    private void collectCandidateConfigurations(Class<?> source, Set<String> candidates) {
        if (source != null) {
            for (Annotation annotation : source.getDeclaredAnnotations()) {
                if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)annotation)) continue;
                this.collectCandidateConfigurations(annotation, candidates);
            }
            this.collectCandidateConfigurations(source.getSuperclass(), candidates);
        }
    }

    private void collectCandidateConfigurations(Annotation annotation, Set<String> candidates) {
        if (ANNOTATION_NAMES.contains(annotation.annotationType().getName())) {
            String[] value = (String[])AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)true).get("value");
            candidates.addAll(Arrays.asList(value));
        }
        this.collectCandidateConfigurations(annotation.annotationType(), candidates);
    }

    @Override
    protected Set<String> getExclusions(AnnotationMetadata metadata, AnnotationAttributes attributes) {
        return Collections.emptySet();
    }

    @Override
    public int getOrder() {
        return super.getOrder() - 1;
    }

    static {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add(ImportAutoConfiguration.class.getName());
        names.add("org.springframework.boot.autoconfigure.test.ImportAutoConfiguration");
        ANNOTATION_NAMES = Collections.unmodifiableSet(names);
    }
}

