/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.info;

import java.io.IOException;
import java.util.Properties;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.info.ProjectInfoProperties;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@EnableConfigurationProperties(value={ProjectInfoProperties.class})
public class ProjectInfoAutoConfiguration {
    private final ProjectInfoProperties properties;

    public ProjectInfoAutoConfiguration(ProjectInfoProperties properties) {
        this.properties = properties;
    }

    @Conditional(value={GitResourceAvailableCondition.class})
    @ConditionalOnMissingBean
    @Bean
    public GitProperties gitProperties() throws Exception {
        return new GitProperties(this.loadFrom(this.properties.getGit().getLocation(), "git"));
    }

    @ConditionalOnResource(resources={"${spring.info.build.location:classpath:META-INF/boot/build.properties}"})
    @ConditionalOnMissingBean
    @Bean
    public BuildProperties buildProperties() throws Exception {
        return new BuildProperties(this.loadFrom(this.properties.getBuild().getLocation(), "build"));
    }

    protected Properties loadFrom(Resource location, String prefix) throws IOException {
        String p = prefix.endsWith(".") ? prefix : prefix + ".";
        Properties source = PropertiesLoaderUtils.loadProperties((Resource)location);
        Properties target = new Properties();
        for (String key : source.stringPropertyNames()) {
            if (!key.startsWith(p)) continue;
            target.put(key.substring(p.length(), key.length()), source.get(key));
        }
        return target;
    }

    static class GitResourceAvailableCondition
    extends SpringBootCondition {
        private final ResourceLoader defaultResourceLoader = new DefaultResourceLoader();

        GitResourceAvailableCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment propertyResolver;
            RelaxedPropertyResolver resolver;
            String location;
            ResourceLoader loader = context.getResourceLoader();
            if (loader == null) {
                loader = this.defaultResourceLoader;
            }
            if ((location = (resolver = new RelaxedPropertyResolver((PropertyResolver)(propertyResolver = context.getEnvironment()), "spring.info.git.")).getProperty("location")) == null && (location = (resolver = new RelaxedPropertyResolver((PropertyResolver)propertyResolver, "spring.git.")).getProperty("properties")) == null) {
                location = "classpath:git.properties";
            }
            boolean match = loader.getResource(location).exists();
            return new ConditionOutcome(match, "Git info " + (match ? "found" : "not found") + " at " + location);
        }
    }
}

