/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jersey;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.jersey.JerseyProperties;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.autoconfigure.web.DispatcherServletAutoConfiguration;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.RegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.filter.RequestContextFilter;

@Configuration
@ConditionalOnClass(name={"org.glassfish.jersey.server.spring.SpringComponentProvider", "javax.servlet.ServletRegistration"})
@ConditionalOnBean(type={"org.glassfish.jersey.server.ResourceConfig"})
@ConditionalOnWebApplication
@AutoConfigureOrder(value=-2147483648)
@AutoConfigureBefore(value={DispatcherServletAutoConfiguration.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
@EnableConfigurationProperties(value={JerseyProperties.class})
public class JerseyAutoConfiguration
implements ServletContextAware {
    private static final Log logger = LogFactory.getLog(JerseyAutoConfiguration.class);
    private final JerseyProperties jersey;
    private final ResourceConfig config;
    private final List<ResourceConfigCustomizer> customizers;
    private String path;

    public JerseyAutoConfiguration(JerseyProperties jersey, ResourceConfig config, ObjectProvider<List<ResourceConfigCustomizer>> customizersProvider) {
        this.jersey = jersey;
        this.config = config;
        this.customizers = (List)customizersProvider.getIfAvailable();
    }

    @PostConstruct
    public void path() {
        this.resolveApplicationPath();
        this.customize();
    }

    private void resolveApplicationPath() {
        this.path = StringUtils.hasLength((String)this.jersey.getApplicationPath()) ? JerseyAutoConfiguration.parseApplicationPath(this.jersey.getApplicationPath()) : JerseyAutoConfiguration.findApplicationPath((ApplicationPath)AnnotationUtils.findAnnotation(this.config.getClass(), ApplicationPath.class));
    }

    private void customize() {
        if (this.customizers != null) {
            AnnotationAwareOrderComparator.sort(this.customizers);
            for (ResourceConfigCustomizer customizer : this.customizers) {
                customizer.customize(this.config);
            }
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public FilterRegistrationBean requestContextFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RequestContextFilter());
        registration.setOrder(this.jersey.getFilter().getOrder() - 1);
        registration.setName("requestContextFilter");
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean(name={"jerseyFilterRegistration"})
    @ConditionalOnProperty(prefix="spring.jersey", name={"type"}, havingValue="filter")
    public FilterRegistrationBean jerseyFilterRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new ServletContainer(this.config));
        registration.setUrlPatterns(Arrays.asList(this.path));
        registration.setOrder(this.jersey.getFilter().getOrder());
        registration.addInitParameter("jersey.config.servlet.filter.contextPath", this.stripPattern(this.path));
        this.addInitParameters((RegistrationBean)registration);
        registration.setName("jerseyFilter");
        registration.setDispatcherTypes(EnumSet.allOf(DispatcherType.class));
        return registration;
    }

    private String stripPattern(String path) {
        if (path.endsWith("/*")) {
            path = path.substring(0, path.lastIndexOf("/*"));
        }
        return path;
    }

    @Bean
    @ConditionalOnMissingBean(name={"jerseyServletRegistration"})
    @ConditionalOnProperty(prefix="spring.jersey", name={"type"}, havingValue="servlet", matchIfMissing=true)
    public ServletRegistrationBean jerseyServletRegistration() {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new ServletContainer(this.config), new String[]{this.path});
        this.addInitParameters((RegistrationBean)registration);
        registration.setName(this.getServletRegistrationName());
        registration.setLoadOnStartup(this.jersey.getServlet().getLoadOnStartup());
        return registration;
    }

    private String getServletRegistrationName() {
        return ClassUtils.getUserClass(this.config.getClass()).getName();
    }

    private void addInitParameters(RegistrationBean registration) {
        for (Map.Entry<String, String> entry : this.jersey.getInit().entrySet()) {
            registration.addInitParameter(entry.getKey(), entry.getValue());
        }
    }

    private static String findApplicationPath(ApplicationPath annotation) {
        if (annotation == null) {
            return "/*";
        }
        return JerseyAutoConfiguration.parseApplicationPath(annotation.value());
    }

    private static String parseApplicationPath(String applicationPath) {
        if (!applicationPath.startsWith("/")) {
            applicationPath = "/" + applicationPath;
        }
        return applicationPath.equals("/") ? "/*" : applicationPath + "/*";
    }

    public void setServletContext(ServletContext servletContext) {
        String servletRegistrationName = this.getServletRegistrationName();
        ServletRegistration registration = servletContext.getServletRegistration(servletRegistrationName);
        if (registration != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Configuring existing registration for Jersey servlet '" + servletRegistrationName + "'"));
            }
            registration.setInitParameters(this.jersey.getInit());
            registration.setInitParameter("jersey.config.disableMetainfServicesLookup", Boolean.TRUE.toString());
        }
    }

    @ConditionalOnClass(value={JacksonFeature.class})
    @ConditionalOnSingleCandidate(value=ObjectMapper.class)
    @Configuration
    static class JacksonResourceConfigCustomizer {
        JacksonResourceConfigCustomizer() {
        }

        @Bean
        public ResourceConfigCustomizer resourceConfigCustomizer() {
            return new ResourceConfigCustomizer(){

                @Override
                public void customize(ResourceConfig config) {
                    config.register(JacksonFeature.class);
                    config.register(ObjectMapperContextResolver.class);
                }
            };
        }

        @Provider
        static class ObjectMapperContextResolver
        implements ContextResolver<ObjectMapper> {
            @Autowired
            private ObjectMapper objectMapper;

            ObjectMapperContextResolver() {
            }

            public ObjectMapper getContext(Class<?> type) {
                return this.objectMapper;
            }
        }
    }

    @Order(value=-2147483648)
    public static final class JerseyWebApplicationInitializer
    implements WebApplicationInitializer {
        public void onStartup(ServletContext servletContext) throws ServletException {
            servletContext.setInitParameter("contextConfigLocation", "<NONE>");
        }
    }
}

