/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import java.util.Collection;
import java.util.LinkedHashMap;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.conditionalcomments.dialect.ConditionalCommentsDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.extras.springsecurity4.dialect.SpringSecurityDialect;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.resourceresolver.SpringResourceResourceResolver;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

@Configuration
@EnableConfigurationProperties(value={ThymeleafProperties.class})
@ConditionalOnClass(value={SpringTemplateEngine.class})
@ConditionalOnMissingClass(value={"org.thymeleaf.templatemode.TemplateMode"})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class ThymeleafAutoConfiguration {
    private static final Log logger = LogFactory.getLog(ThymeleafAutoConfiguration.class);

    @Configuration
    @ConditionalOnWebApplication
    protected static class ThymeleafResourceHandlingConfig {
        protected ThymeleafResourceHandlingConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledResourceChain
        public ResourceUrlEncodingFilter resourceUrlEncodingFilter() {
            return new ResourceUrlEncodingFilter();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    protected static class ThymeleafViewResolverConfiguration {
        private final ThymeleafProperties properties;
        private final SpringTemplateEngine templateEngine;

        protected ThymeleafViewResolverConfiguration(ThymeleafProperties properties, SpringTemplateEngine templateEngine) {
            this.properties = properties;
            this.templateEngine = templateEngine;
        }

        @Bean
        @ConditionalOnMissingBean(name={"thymeleafViewResolver"})
        @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
        public ThymeleafViewResolver thymeleafViewResolver() {
            ThymeleafViewResolver resolver = new ThymeleafViewResolver();
            resolver.setTemplateEngine(this.templateEngine);
            resolver.setCharacterEncoding(this.properties.getEncoding().name());
            resolver.setContentType(this.appendCharset(this.properties.getContentType(), resolver.getCharacterEncoding()));
            resolver.setExcludedViewNames(this.properties.getExcludedViewNames());
            resolver.setViewNames(this.properties.getViewNames());
            resolver.setOrder(0x7FFFFFFA);
            return resolver;
        }

        private String appendCharset(MimeType type, String charset) {
            if (type.getCharSet() != null) {
                return type.toString();
            }
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("charset", charset);
            parameters.putAll(type.getParameters());
            return new MimeType(type, parameters).toString();
        }
    }

    @Configuration
    @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.EIGHT)
    @ConditionalOnClass(value={Java8TimeDialect.class})
    protected static class ThymeleafJava8TimeDialect {
        protected ThymeleafJava8TimeDialect() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Java8TimeDialect java8TimeDialect() {
            return new Java8TimeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={ConditionalCommentsDialect.class})
    protected static class ThymeleafConditionalCommentsDialectConfiguration {
        protected ThymeleafConditionalCommentsDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ConditionalCommentsDialect conditionalCommentsDialect() {
            return new ConditionalCommentsDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringSecurityDialect.class})
    protected static class ThymeleafSecurityDialectConfiguration {
        protected ThymeleafSecurityDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringSecurityDialect securityDialect() {
            return new SpringSecurityDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataAttributeDialect.class})
    protected static class DataAttributeDialectConfiguration {
        protected DataAttributeDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAttributeDialect dialect() {
            return new DataAttributeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"nz.net.ultraq.thymeleaf.LayoutDialect"})
    protected static class ThymeleafWebLayoutConfiguration {
        protected ThymeleafWebLayoutConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public LayoutDialect layoutDialect() {
            return new LayoutDialect();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringTemplateEngine.class})
    protected static class ThymeleafDefaultConfiguration {
        private final Collection<ITemplateResolver> templateResolvers;
        private final Collection<IDialect> dialects;

        public ThymeleafDefaultConfiguration(Collection<ITemplateResolver> templateResolvers, ObjectProvider<Collection<IDialect>> dialectsProvider) {
            this.templateResolvers = templateResolvers;
            this.dialects = (Collection)dialectsProvider.getIfAvailable();
        }

        @Bean
        public SpringTemplateEngine templateEngine() {
            SpringTemplateEngine engine = new SpringTemplateEngine();
            for (ITemplateResolver templateResolver : this.templateResolvers) {
                engine.addTemplateResolver(templateResolver);
            }
            if (!CollectionUtils.isEmpty(this.dialects)) {
                for (IDialect dialect : this.dialects) {
                    engine.addDialect(dialect);
                }
            }
            return engine;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(name={"defaultTemplateResolver"})
    public static class DefaultTemplateResolverConfiguration {
        private final ThymeleafProperties properties;
        private final ApplicationContext applicationContext;

        public DefaultTemplateResolverConfiguration(ThymeleafProperties properties, ApplicationContext applicationContext) {
            this.properties = properties;
            this.applicationContext = applicationContext;
        }

        @PostConstruct
        public void checkTemplateLocationExists() {
            TemplateLocation location;
            boolean checkTemplateLocation = this.properties.isCheckTemplateLocation();
            if (checkTemplateLocation && !(location = new TemplateLocation(this.properties.getPrefix())).exists((ResourcePatternResolver)this.applicationContext)) {
                logger.warn((Object)("Cannot find template location: " + location + " (please add some templates or check " + "your Thymeleaf configuration)"));
            }
        }

        @Bean
        public TemplateResolver defaultTemplateResolver() {
            TemplateResolver resolver = new TemplateResolver();
            resolver.setResourceResolver((IResourceResolver)this.thymeleafResourceResolver());
            resolver.setPrefix(this.properties.getPrefix());
            resolver.setSuffix(this.properties.getSuffix());
            resolver.setTemplateMode(this.properties.getMode());
            if (this.properties.getEncoding() != null) {
                resolver.setCharacterEncoding(this.properties.getEncoding().name());
            }
            resolver.setCacheable(this.properties.isCache());
            Integer order = this.properties.getTemplateResolverOrder();
            if (order != null) {
                resolver.setOrder(order);
            }
            return resolver;
        }

        @Bean
        public SpringResourceResourceResolver thymeleafResourceResolver() {
            return new SpringResourceResourceResolver();
        }
    }
}

