/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.neo4j;

import java.util.List;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.neo4j.SessionFactoryProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.neo4j.config.Neo4jConfiguration;
import org.springframework.data.neo4j.template.Neo4jOperations;

@Configuration
@ConditionalOnClass(value={Neo4jSession.class, Neo4jOperations.class})
@ConditionalOnMissingBean(value={Neo4jOperations.class})
@EnableConfigurationProperties(value={Neo4jProperties.class})
public class Neo4jAutoConfiguration {

    @Configuration
    static class Neo4jConfigurationConfiguration {
        private final Neo4jProperties properties;

        Neo4jConfigurationConfiguration(Neo4jProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean
        public org.neo4j.ogm.config.Configuration configuration() {
            return this.properties.createConfiguration();
        }
    }

    @Configuration
    @Import(value={Neo4jConfigurationConfiguration.class})
    static class SessionFactoryProviderConfiguration
    implements BeanFactoryAware {
        private final org.neo4j.ogm.config.Configuration configuration;
        private ConfigurableListableBeanFactory beanFactory;

        SessionFactoryProviderConfiguration(org.neo4j.ogm.config.Configuration configuration) {
            this.configuration = configuration;
        }

        @Bean
        @ConditionalOnMissingBean
        public SessionFactoryProvider sessionFactoryProvider() {
            SessionFactoryProvider provider = new SessionFactoryProvider();
            provider.setConfiguration(this.configuration);
            provider.setPackagesToScan(this.getPackagesToScan());
            return provider;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }

        protected String[] getPackagesToScan() {
            if (AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                List<String> basePackages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
                return basePackages.toArray(new String[basePackages.size()]);
            }
            return new String[0];
        }
    }

    @Configuration
    @Import(value={SessionFactoryProviderConfiguration.class})
    public static class SpringBootNeo4jConfiguration
    extends Neo4jConfiguration {
        private final ObjectProvider<SessionFactoryProvider> sessionFactoryProvider;

        public SpringBootNeo4jConfiguration(ObjectProvider<SessionFactoryProvider> sessionFactoryProvider) {
            this.sessionFactoryProvider = sessionFactoryProvider;
        }

        public SessionFactory getSessionFactory() {
            return ((SessionFactoryProvider)this.sessionFactoryProvider.getObject()).getSessionFactory();
        }

        @Bean
        @Scope(scopeName="${spring.data.neo4j.session.scope:singleton}", proxyMode=ScopedProxyMode.TARGET_CLASS)
        public Session getSession() throws Exception {
            return this.getSessionFactory().openSession();
        }
    }
}

