/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.annotation.Bean;

abstract class DataSourceConfiguration {
    DataSourceConfiguration() {
    }

    protected <T> T createDataSource(DataSourceProperties properties, Class<? extends javax.sql.DataSource> type) {
        return (T)properties.initializeDataSourceBuilder().type(type).build();
    }

    @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"})
    static class Generic {
        Generic() {
        }

        @Bean
        public javax.sql.DataSource dataSource(DataSourceProperties properties) {
            return properties.initializeDataSourceBuilder().build();
        }
    }

    @ConditionalOnClass(value={BasicDataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.apache.commons.dbcp2.BasicDataSource", matchIfMissing=true)
    static class Dbcp2
    extends DataSourceConfiguration {
        Dbcp2() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.dbcp2")
        public BasicDataSource dataSource(DataSourceProperties properties) {
            return (BasicDataSource)this.createDataSource(properties, BasicDataSource.class);
        }
    }

    @ConditionalOnClass(value={HikariDataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="com.zaxxer.hikari.HikariDataSource", matchIfMissing=true)
    static class Hikari
    extends DataSourceConfiguration {
        Hikari() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.hikari")
        public HikariDataSource dataSource(DataSourceProperties properties) {
            return (HikariDataSource)this.createDataSource(properties, HikariDataSource.class);
        }
    }

    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="org.apache.tomcat.jdbc.pool.DataSource", matchIfMissing=true)
    static class Tomcat
    extends DataSourceConfiguration {
        Tomcat() {
        }

        @Bean
        @ConfigurationProperties(prefix="spring.datasource.tomcat")
        public DataSource dataSource(DataSourceProperties properties) {
            DataSource dataSource = (DataSource)this.createDataSource(properties, DataSource.class);
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl((String)properties.determineUrl());
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                dataSource.setTestOnBorrow(true);
                dataSource.setValidationQuery(validationQuery);
            }
            return dataSource;
        }
    }
}

