/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.core.env.Environment;

public class ReactiveMongoClientFactory {
    private final MongoProperties properties;
    private final Environment environment;

    public ReactiveMongoClientFactory(MongoProperties properties, Environment environment) {
        this.properties = properties;
        this.environment = environment;
    }

    public MongoClient createMongoClient(MongoClientSettings settings) {
        Integer embeddedPort = this.getEmbeddedPort();
        if (embeddedPort != null) {
            return this.createEmbeddedMongoClient(settings, embeddedPort);
        }
        return this.createNetworkMongoClient(settings);
    }

    private Integer getEmbeddedPort() {
        String localPort;
        if (this.environment != null && (localPort = this.environment.getProperty("local.mongo.port")) != null) {
            return Integer.valueOf(localPort);
        }
        return null;
    }

    private MongoClient createEmbeddedMongoClient(MongoClientSettings settings, int port) {
        MongoClientSettings.Builder builder = this.builder(settings);
        String host = this.properties.getHost() == null ? "localhost" : this.properties.getHost();
        ClusterSettings clusterSettings = ClusterSettings.builder().hosts(Collections.singletonList(new ServerAddress(host, port))).build();
        builder.clusterSettings(clusterSettings);
        return MongoClients.create((MongoClientSettings)builder.build());
    }

    private MongoClient createNetworkMongoClient(MongoClientSettings settings) {
        if (this.hasCustomAddress() || this.hasCustomCredentials()) {
            if (this.properties.getUri() != null) {
                throw new IllegalStateException("Invalid mongo configuration, either uri or host/port/credentials must be specified");
            }
            MongoClientSettings.Builder builder = this.builder(settings);
            if (this.hasCustomCredentials()) {
                ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
                String database = this.properties.getAuthenticationDatabase() == null ? this.properties.getMongoClientDatabase() : this.properties.getAuthenticationDatabase();
                credentials.add(MongoCredential.createCredential((String)this.properties.getUsername(), (String)database, (char[])this.properties.getPassword()));
                builder.credentialList(credentials);
            }
            String host = this.properties.getHost() == null ? "localhost" : this.properties.getHost();
            int port = this.properties.getPort() != null ? this.properties.getPort() : 27017;
            ClusterSettings clusterSettings = ClusterSettings.builder().hosts(Collections.singletonList(new ServerAddress(host, port))).build();
            builder.clusterSettings(clusterSettings);
            return MongoClients.create((MongoClientSettings)builder.build());
        }
        ConnectionString connectionString = new ConnectionString(this.properties.determineUri());
        return MongoClients.create((MongoClientSettings)this.createBuilder(settings, connectionString).build());
    }

    private MongoClientSettings.Builder createBuilder(MongoClientSettings settings, ConnectionString connectionString) {
        MongoClientSettings.Builder builder = this.builder(settings).clusterSettings(ClusterSettings.builder().applyConnectionString(connectionString).build()).connectionPoolSettings(ConnectionPoolSettings.builder().applyConnectionString(connectionString).build()).serverSettings(ServerSettings.builder().applyConnectionString(connectionString).build()).credentialList(connectionString.getCredentialList()).sslSettings(SslSettings.builder().applyConnectionString(connectionString).build()).socketSettings(SocketSettings.builder().applyConnectionString(connectionString).build());
        if (connectionString.getReadPreference() != null) {
            builder.readPreference(connectionString.getReadPreference());
        }
        if (connectionString.getReadConcern() != null) {
            builder.readConcern(connectionString.getReadConcern());
        }
        if (connectionString.getWriteConcern() != null) {
            builder.writeConcern(connectionString.getWriteConcern());
        }
        if (connectionString.getApplicationName() != null) {
            builder.applicationName(connectionString.getApplicationName());
        }
        return builder;
    }

    private boolean hasCustomAddress() {
        return this.properties.getHost() != null || this.properties.getPort() != null;
    }

    private boolean hasCustomCredentials() {
        return this.properties.getUsername() != null && this.properties.getPassword() != null;
    }

    private MongoClientSettings.Builder builder(MongoClientSettings settings) {
        if (settings == null) {
            return MongoClientSettings.builder();
        }
        return MongoClientSettings.builder((MongoClientSettings)settings);
    }
}

